//-----------------------------
var MSC_langIndex = -1;
var MSC_langCode = "";
//--------------------------------------------------------------
//	言語コード	MSC_langIndex	言語名
//--------------------------------------------------------------
const MSC_langTypes = [
	"ja",	//	ja-JP	0		日本語
	"jr",	//	ja-JP	1		日本語（ルビ付き）	ISO 639-1 には存在しない（本システムでの独自拡張）
	"en",	//	en-US	2		英語
	"ko",	//	ko-KR	3		韓国語
/*
	"fr",	//	fr-FR	4		フランス語
	"es",	//	es-ES	5		スペイン語
	"it",	//	it-IT	6		イタリア語
	"de",	//	de-DE	7		ドイツ語
	"ru",	//	ru-RU	8		ロシア語
	"zh",	//	zh-CN	9		中国語（簡体）
	"zm",	//	zh-TW	10		中国語（繁体）		ISO 639-1 には存在しない（本システムでの独自拡張）
	"pt",	//	pt-PT	11		ポルトガル語
	"nl",	//	nl-NL	12		オランダ語
	"el",	//	el-GR	13		ギリシャ語
	"tr",	//	tr-TR	14		トルコ語
	"id",	//	id-ID	15		インドネシア語
	"vi",	//	vi-VN	16		ベトナム語
	"th",	//	th-TH	17		タイ語
	"hi",	//	hi-IN	18		ヒンディー語
	"km",	//	km-KH	19		カンボジア語
	"tl",	//	tl-PH	20		タガログ語
	"ne",	//	ne-NP	21		ネパール語
	"my",	//	my-MM	22		ビルマ語
	"mn",	//	mn-MN	23		モンゴル語
	"uk",	//	uk-UA	24		ウクライナ語
*/
];

//-----------------------------
const MSC_langStr = [

/*
音部記号
拍子記号
調号
速度記号
メトロノーム記号
メトロノーム記号の基準音符
楽譜行数
歌詞番数
小節線
上へ
全音符
付点２分音符
２分音符
付点４分音符
４分音符
付点８分音符
８分音符
16分音符
シャープ
ナチュラル
タイ/スラーの開始
スラーの終了
アーティキュレーションの削除
アクセント
和音の設定
分離
３連符設定
下へ
全音符
付点２分音符
２分音符
付点４分音符
４分音符
付点８分音符
８分音符
16分音符
フラット
臨時記号の削除
タイ/スラーの開始を削除
スラーの終了を削除
スタッカート
テヌート
その他のアーティキュレーション
和音の解除
結合
３連符の解除
強弱記号
反復記号
Undo
Redo
新規
開く
印刷
演奏
abcエディタの表示/非表示
abcエディタ
演奏の終了
スタッカーティッシモ
アップボー
ダウンボー
ロール
アッパーモルデント
ロワーモルデント
トリル
ターン
フェルマータ
ハ長調・イ短調
ト長調・ホ短調
ニ長調・ロ短調
イ長調・嬰ヘ短調
ホ長調・嬰ハ短調
ロ長調・嬰ト短調
嬰ヘ長調・嬰ニ短調
嬰ハ長調・嬰イ短調
ヘ長調・ニ短調
変ロ長調・ト短調
変ホ長調・ハ短調
変イ長調・ヘ短調
変ニ長調・変ロ短調
変ト長調・変ホ短調
変ハ長調・変イ短調
速度指定なし
１行～16行
歌詞なし
歌詞１番まで
歌詞２番まで
歌詞３番まで
１番
２番
３番
はい
いいえ
挿入
タイトル
作者
印刷内容
楽譜
abcソース
キャンセル
強弱なし
始点
終点
反復なし
楽譜データを初期化します。よいですか？
繰り返し
最初から
演奏 / 一時停止
演奏位置の変更
演奏中
*/

	//================================================
	//MSC-Editor for School
	//<ruby>漢<rp>(</rp><rt>かん</rt><rp>)</rp>字<rp>(</rp><rt>じ</rt><rp>)</rp></ruby>
	//<ruby>明日<rp>(</rp><rt>あした</rt><rp>)</rp></ruby>
	//================================================
	[	"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"MSC-Editor for School",
		"",
		"",
		"",
		"",
	],

	//================================================
	//音部記号
	//================================================
	[	"音部記号",
		"音部記号",
		"Clef",
		"음자리표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//拍子記号
	//================================================
	[	"拍子記号",
		"拍子記号",
		"Time Signature",
		"박자표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],


	//================================================
	//調号
	//================================================
	[	"調号",
		"調号",
		"Key Signature",
		"조표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//速度記号
	//================================================
	[	"速度記号",
		"速度記号",
		"Tempo Marking",
		"속도 표기",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//メトロノーム記号
	//================================================
	[	"メトロノーム記号",
		"メトロノーム記号",
		"Metronome Marking",
		"메트로놈 표기",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//メトロノーム記号の基準音符
	//================================================
	[	"メトロノーム記号の基準音符",
		"メトロノーム記号の基準音符",
		"Reference Note of Metronome Marking",
		"메트로놈 표기의 기준 음표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//楽譜行数
	//================================================
	[	"楽譜行数",
		"楽譜行数",
		"Number of Staff Lines",
		"악보 행 수",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//歌詞番数
	//================================================
	[	"歌詞番数",
		"歌詞番数",
		"Lyric Number",
		"가사 번호",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//小節線
	//================================================
	[	"小節線",
		"小節線",
		"Barline",
		"소절선",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//上へ
	//================================================
	[	"上へ",
		"上へ",
		"Up",
		"위로",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//全音符
	//================================================
	[	"全音符",
		"全音符",
		"Whole Note",
		"온음표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//付点２分音符
	//================================================
	[	"付点２分音符",
		"付点２分音符",
		"Dotted Half Note",
		"점2분음표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//２分音符
	//================================================
	[	"２分音符",
		"２分音符",
		"Half Note",
		"2분음표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//付点４分音符
	//================================================
	[	"付点４分音符",
		"付点４分音符",
		"Dotted Quarter Note",
		"점4분음표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//４分音符
	//================================================
	[	"４分音符",
		"４分音符",
		"Quarter Note",
		"4분음표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//付点８分音符
	//================================================
	[	"付点８分音符",
		"付点８分音符",
		"Dotted Eighth Note",
		"점8분음표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//８分音符
	//================================================
	[	"８分音符",
		"８分音符",
		"Eighth Note",
		"8분음표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//16分音符
	//================================================
	[	"16分音符",
		"16分音符",
		"Sixteenth Note",
		"16분음표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//シャープ
	//================================================
	[	"シャープ",
		"シャープ",
		"Sharp",
		"샤프",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//ナチュラル
	//================================================
	[	"ナチュラル",
		"ナチュラル",
		"Natural",
		"내추럴",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//タイ/スラーの開始
	//================================================
	[	"タイ/スラーの開始",
		"タイ/スラーの開始",
		"Tie/Slur Start",
		"타이/슬러 시작",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//スラーの終了
	//================================================
	[	"スラーの終了",
		"スラーの終了",
		"Slur End",
		"슬러 종료",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//アーティキュレーションの削除
	//================================================
	[	"アーティキュレーションの削除",
		"アーティキュレーションの削除",
		"Remove Articulation",
		"아티큘레이션 삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//アクセント
	//================================================
	[	"アクセント",
		"アクセント",
		"Accent",
		"악센트",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//和音の設定
	//================================================
	[	"和音の設定",
		"和音の設定",
		"Chord Settings",
		"화음 설정",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//装飾音符の設定
	//================================================
	[	"装飾音符の設定",
		"装飾音符の設定",
		"Grace note settings",
		"장식 음표 설정",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//短前打音
	//================================================
	[	"短前打音",
		"短前打音",
		"Short Appoggiatura",
		"짧은 앞꾸밈음",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//短前打音の削除
	//================================================
	[	"短前打音の削除",
		"短前打音の削除",
		"Remove Short Appoggiatura",
		"짧은 앞꾸밈음 삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//音符・休符の削除（不完全小節化）
	//================================================
	[	"音符・休符の削除（不完全小節化）",
		"短前打音の削除",
		"Remove Notes and Rests (Create Incomplete Measure)",
		"음표 및 쉼표 삭제 (불완전 마디화)",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//完全小節に戻す
	//================================================
	[	"完全小節に戻す",
		"完全小節に戻す",
		"Restore Complete Measure",
		"완전한 마디로 복원",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//複旋律の追加
	//================================================
	[	"複旋律の追加",
		"複旋律の追加",
		"Add Counterpoint",
		"복선율 추가",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//複旋律の削除
	//================================================
	[	"複旋律の削除",
		"複旋律の削除",
		"Remove Counterpoint",
		"복선율 삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],









	//================================================
	//分離
	//================================================
	[	"分離",
		"分離",
		"Separate",
		"분리",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//３連符設定
	//================================================
	[	"３連符設定",
		"３連符設定",
		"Set Triplet",
		"3연음 설정",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//下へ
	//================================================
	[	"下へ",
		"下へ",
		"Down",
		"아래로",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//全休符
	//================================================
	[	"全休符",
		"全休符",
		"Whole Rest",
		"온쉼표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//付点２分休符
	//================================================
	[	"付点２分休符",
		"付点２分休符",
		"Dotted Half Rest",
		"점2분쉼표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//２分休符
	//================================================
	[	"２分休符",
		"２分休符",
		"Half Rest",
		"2분쉼표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//付点４分休符
	//================================================
	[	"付点４分休符",
		"付点４分休符",
		"Dotted Quarter Rest",
		"점4분쉼표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//４分休符
	//================================================
	[	"４分休符",
		"４分休符",
		"Quarter Rest",
		"4분쉼표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//付点８分休符
	//================================================
	[	"付点８分休符",
		"付点８分休符",
		"Dotted Eighth Rest",
		"점8분쉼표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//８分休符
	//================================================
	[	"８分休符",
		"８分休符",
		"Eighth Rest",
		"8분쉼표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//16分休符
	//================================================
	[	"16分休符",
		"16分休符",
		"Sixteenth Rest",
		"16분쉼표",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//フラット
	//================================================
	[	"フラット",
		"フラット",
		"Flat",
		"플랫",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//臨時記号の削除
	//================================================
	[	"臨時記号の削除",
		"臨時記号の削除",
		"Remove Accidental",
		"임시표 삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//タイ/スラーの開始を削除
	//================================================
	[	"タイ/スラーの開始を削除",
		"タイ/スラーの開始を削除",
		"Remove Tie/Slur Start",
		"타이/슬러 시작 삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//スラーの終了を削除
	//================================================
	[	"スラーの終了を削除",
		"スラーの終了を削除",
		"Remove Slur End",
		"슬러 종료 삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//スタッカート
	//================================================
	[	"スタッカート",
		"スタッカート",
		"Staccato",
		"스타카토",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//テヌート
	//================================================
	[	"テヌート",
		"テヌート",
		"Tenuto",
		"테누토",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//その他のアーティキュレーション
	//================================================
	[	"その他のアーティキュレーション",
		"その他のアーティキュレーション",
		"Other Articulations",
		"기타 아티큘레이션",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//和音の解除
	//================================================
	[	"和音の解除",
		"和音の解除",
		"Remove Chord",
		"화음 해제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//結合
	//================================================
	[	"結合",
		"結合",
		"Combine",
		"결합",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//３連符の解除
	//================================================
	[	"３連符の解除",
		"３連符の解除",
		"Remove Triplet",
		"3연음 해제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//強弱記号
	//================================================
	[	"強弱記号",
		"強弱記号",
		"Dynamics Marking",
		"강약기호",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//反復記号
	//================================================
	[	"反復記号",
		"反復記号",
		"Repeat Marking",
		"반복기호",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//Undo
	//================================================
	[	"Undo",
		"Undo",
		"Undo",
		"실행 취소",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//Redo
	//================================================
	[	"Redo",
		"Redo",
		"Redo",
		"다시 실행",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//新規
	//================================================
	[	"新規",
		"新規",
		"New",
		"새로 만들기",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//開く
	//================================================
	[	"開く",
		"開く",
		"Open",
		"열기",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//印刷
	//================================================
	[	"印刷",
		"印刷",
		"Print",
		"인쇄",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//演奏
	//================================================
	[	"演奏",
		"演奏",
		"Play",
		"연주",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//abcエディタの表示/非表示
	//================================================
	[	"abcエディタの表示/非表示",
		"abcエディタの表示/非表示",
		"Show/Hide abc Editor",
		"abc 에디터 표시/숨기기",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//abcエディタ
	//================================================
	[	"abcエディタ",
		"abcエディタ",
		"abc Editor",
		"abc 에디터",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//演奏の終了
	//================================================
	[	"演奏の終了",
		"演奏の終了",
		"Stop Playing",
		"연주 종료",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//スタッカーティッシモ
	//================================================
	[	"スタッカーティッシモ",
		"スタッカーティッシモ",
		"Staccatissimo",
		"스타카티시모",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//アップボー
	//================================================
	[	"アップボー",
		"アップボー",
		"Up Bow",
		"업 보우",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//ダウンボー
	//================================================
	[	"ダウンボー",
		"ダウンボー",
		"Down Bow",
		"다운 보우",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//ロール
	//================================================
	[	"ロール",
		"ロール",
		"Roll",
		"롤",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//アッパーモルデント
	//================================================
	[	"アッパーモルデント",
		"アッパーモルデント",
		"Upper Mordent",
		"상 모르덴트",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//ロワーモルデント
	//================================================
	[	"ロワーモルデント",
		"ロワーモルデント",
		"Lower Mordent",
		"하 모르덴트",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//トリル
	//================================================
	[	"トリル",
		"トリル",
		"Trill",
		"트릴",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//ターン
	//================================================
	[	"ターン",
		"ターン",
		"Turn",
		"턴",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//フェルマータ
	//================================================
	[	"フェルマータ",
		"フェルマータ",
		"Fermata",
		"페르마타",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//速度指定なし
	//================================================
	[	"速度指定なし",
		"速度指定なし",
		"No Tempo Marking",
		"속도 지정 없음",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//歌詞なし
	//================================================
	[	"歌詞なし",
		"歌詞なし",
		"No Lyrics",
		"가사 없음",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//歌詞１番まで
	//================================================
	[	"１番まで",
		"１番まで",
		"Up to 1st",
		"1절까지",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//歌詞２番まで
	//================================================
	[	"２番まで",
		"２番まで",
		"Up to 2nd",
		"2절까지",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//歌詞３番まで
	//================================================
	[	"３番まで",
		"３番まで",
		"Up to 3rd",
		"3절까지",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//１番
	//================================================
	[	"１番",
		"１番",
		"1st",
		"1절",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//２番
	//================================================
	[	"２番",
		"２番",
		"2nd",
		"2절",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//３番
	//================================================
	[	"３番",
		"３番",
		"3rd",
		"3절",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//はい
	//================================================
	[	"はい",
		"はい",
		"Yes",
		"예",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//いいえ
	//================================================
	[	"いいえ",
		"いいえ",
		"No",
		"아니요",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//挿入
	//================================================
	[	"挿入",
		"挿入",
		"Insert",
		"삽입",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//タイトル
	//================================================
	[	"タイトル",
		"タイトル",
		"Title",
		"제목",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//作者
	//================================================
	[	"作者",
		"作者",
		"Composer/Author",
		"작곡자/작가",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//印刷内容
	//================================================
	[	"印刷内容",
		"印刷内容",
		"Print Content",
		"인쇄 내용",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//楽譜
	//================================================
	[	"楽譜",
		"楽譜",
		"Sheet Music",
		"악보",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//abcソース
	//================================================
	[	"abcソース",
		"abcソース",
		"abc Source",
		"abc 소스",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//OK
	//================================================
	[	"OK",
		"OK",
		"OK",
		"확인",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//キャンセル
	//================================================
	[	"キャンセル",
		"キャンセル",
		"Cancel",
		"취소",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//強弱なし
	//================================================
	[	"強弱なし",
		"強弱なし",
		"No Dynamics",
		"강약 없음",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//始点
	//================================================
	[	"始点",
		"始点",
		"Start",
		"시작점",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//終点
	//================================================
	[	"終点",
		"終点",
		"End",
		"끝점",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//反復なし
	//================================================
	[	"反復なし",
		"反復なし",
		"No Repeat",
		"반복 없음",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//楽譜データを初期化します。よいですか？
	//================================================
	[	"楽譜データを初期化します。よいですか？",
		"楽譜データを初期化します。よいですか？",
		"Initialize Sheet Music Data. Are you sure?",
		"악보 데이터를 초기화합니다. 괜찮으시겠습니까?",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//繰り返し
	//================================================
	[	"繰り返し",
		"繰り返し",
		"Toggle Play once / Repeat",
		"반복",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//最初から
	//================================================
	[	"最初から",
		"最初から",
		"Go to Beginning",
		"처음부터",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//演奏 / 一時停止
	//================================================
	[	"演奏 / 一時停止",
		"演奏 / 一時停止",
		"Play / Pause",
		"연주 / 일시 정지",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//演奏位置の変更
	//================================================
	[	"演奏位置の変更",
		"演奏位置の変更",
		"Change the Playback Position",
		"연주 위치 변경",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//演奏モード
	//================================================
	[	"演奏モード",
		"演奏モード",
		"Play Mode",
		"연주 모드",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//ブレス
	//================================================
	[	"ブレス",
		"ブレス",
		"Breath",
		"브레스",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//ブレスの削除
	//================================================
	[	"ブレスの削除",
		"ブレスの削除",
		"Remove Breath",
		"브레스 삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//小節数
	//================================================
	[	"小節数",
		"小節数",
		"Number of Bars",
		"소절 수",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//曲名・作者を含める
	//================================================
	[	"曲名・作者を含める",
		"曲名・作者を含める",
		"Include Title and Composer",
		"곡명 및 작곡가 포함",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//楽譜編集画面に表示
	//================================================
	[	"楽譜編集画面に表示",
		"楽譜編集画面に表示",
		"Display in Score Editing Screen",
		"악보 편집 화면에 표시",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//段番号
	//================================================
	[	"段番号",
		"段番号",
		"Line Number",
		"단 번호",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//楽譜段数
	//================================================
	[	"楽譜段数",
		"楽譜段数",
		"Number of Lines",
		"악보 단 수",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//1小節
	//================================================
	[	"1小節",
		"1小節",
		"1 Bar",
		"1소절",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//%1小節
	//================================================
	[	"%1小節",
		"%1小節",
		"%1 Bars",
		"%1소절",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//1段
	//================================================
	[	"1段",
		"1段",
		"1 Line",
		"1단",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//%1段
	//================================================
	[	"%1段",
		"%1段",
		"%1 Lines",
		"%1단",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//第 1 段
	//================================================
	[	"第 1 段",
		"第 1 段",
		"1st Line",
		"제 1 단",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//第 2 段
	//================================================
	[	"第 2 段",
		"第 2 段",
		"2nd Line",
		"제 2 단",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//第 3 段
	//================================================
	[	"第 3 段",
		"第 3 段",
		"3rd Line",
		"제 3 단",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//第 %1 段
	//================================================
	[	"第 %1 段",
		"第 %1 段",
		"%1th Line",
		"제 %1 단",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//新規楽曲.msd
	//================================================
	[	"新規楽曲.msd",
		"新規楽曲.msd",
		"NewSong.msd",
		"새곡.msd",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//再編集楽曲.msd
	//================================================
	[	"再編集楽曲.msd",
		"再編集楽曲.msd",
		"ReEditSong.msd",
		"곡재편집.msd",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//６小節以上を指定すると、段が画面に収まりませんが、音符や休符を設定すれば、画面内に収まります。
	//================================================
	[	"６小節以上を指定すると、当初は段が画面に収まりませんが、音符や休符を設定すれば、収まります。",
		"６小節以上を指定すると、当初は段が画面に収まりませんが、音符や休符を設定すれば、収まります。",
		"When specifying 6 or more measures, initially the staff does not fit on the screen, but when notes or rests are set, it fits.",
		"6마디 이상을 지정하면, 당초는 단이 화면에 들어가지 않습니다만, 음표나 휴부를 설정하면, 맞습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],





	//#############################################################
	//	ここから操作説明用
	//#############################################################
	//================================================
	//楽譜エディタ（MSC-Editor）操作マニュアル
	//================================================
	[	"楽譜エディタ（MSC-Editor）操作マニュアル",
		"楽譜エディタ（MSC-Editor）操作マニュアル",
		"Music Score Editor (MSC-Editor) Operation Manual",
		"악보 편집기(MSC-Editor) 조작 매뉴얼",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//画面上のボタン等をクリックすると、操作説明が表示されます。
	//================================================
	[	"画面上のボタン等をクリックすると、操作説明が表示されます。",
		"画面上のボタン等をクリックすると、操作説明が表示されます。",
		"Clicking on a button on the screen will display instructions on how to operate it.",
		"화면상의 버튼 등을 클릭하면 조작 설명이 표시됩니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//音部記号を、次の中から選択します。
	//================================================
	[	"音部記号を、次の中から選択します。",
		"音部記号を、次の中から選択します。",
		"Select the clef from the following:",
		"음자리표를 다음 중에서 선택합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//音部記号を変更すると、編集中の楽譜はクリアされます。
	//================================================
	[	"音部記号を変更すると、編集中の楽譜はクリアされます。",
		"音部記号を変更すると、編集中の楽譜はクリアされます。",
		"When you change the clef, the music you were editing will be cleared.",
		"음부 기호를 변경하면 편집 중인 악보가 지워집니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//調号を、次の中から選択します。
	//================================================
	[	"調号を、次の中から選択します。",
		"調号を、次の中から選択します。",
		"Select the key signature:",
		"디코딩을 다음 중에서 선택합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//拍子記号を、次の中から選択します。
	//================================================
	[	"拍子記号を、次の中から選択します。",
		"拍子記号を、次の中から選択します。",
		"Select the time signature:",
		"박자 기호를 다음 중에서 선택합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//拍子記号を変更すると、編集中の楽譜がクリアされる場合があります。
	//================================================
	[	"拍子記号を変更すると、編集中の楽譜がクリアされる場合があります。",
		"拍子記号を変更すると、編集中の楽譜がクリアされる場合があります。",
		"Changing the time signature may clear the music you are editing.",
		"박자 기호를 변경하면 편집 중인 악보가 지워질 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//曲名・作者
	//================================================
	[	"曲名・作者",
		"曲名・作者",
		"Song title and author",
		"곡명·작자",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//曲名と作者を入力します。
	//================================================
	[	"曲名と作者を入力します。",
		"曲名と作者を入力します。",
		"Enter the song title and author.",
		"노래 이름과 저자를 입력합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//曲名は２行まで入力でき、作者は３行まで入力できます。
	//================================================
	[	"曲名は２行まで入力でき、作者は３行まで入力できます。",
		"曲名は２行まで入力でき、作者は３行まで入力できます。",
		"You can enter up to two lines for the song title and up to three lines for the composer.",
		"곡명은 2행까지 입력할 수 있고, 저자는 3행까지 입력할 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//［楽譜編集画面に表示］をチェックすると、譜面上に曲名と作者が表示されます。
	//================================================
	[	"［楽譜編集画面に表示］をチェックすると、譜面上に曲名と作者が表示されます。",
		"［楽譜編集画面に表示］をチェックすると、譜面上に曲名と作者が表示されます。",
		"If you check [Show on score editing screen], the song title and author will be displayed on the score.",
		"[악보 편집 화면에 표시]를 체크하면 악보에 곡명과 작성자가 표시됩니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//速度記号を、次の中から選択します。
	//================================================
	[	"速度記号を、次の中から選択します。",
		"速度記号を、次の中から選択します。",
		"Select the speed symbol from the following:",
		"속도 기호를 다음 중에서 선택합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//速度指定なし
	//================================================
	[	"速度指定なし",
		"速度指定なし",
		"No speed specified",
		"속도 지정 없음",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//速度記号を選択すると、( )内の値が、メトロノーム記号欄に表示されます。
	//================================================
	[	"速度記号を選択すると、( )内の値が、メトロノーム記号欄に表示されます。",
		"速度記号を選択すると、( )内の値が、メトロノーム記号欄に表示されます。",
		"When you select a tempo symbol, the value in parentheses will be displayed in the metronome symbol field.",
		"속도 기호를 선택하면 ( )의 값이 메트로놈 기호 열에 표시됩니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//メトロノーム記号
	//================================================
	[	"メトロノーム記号",
		"メトロノーム記号",
		"Metronome mark",
		"메트로놈 기호",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//メトロノーム記号の値を入力します。
	//================================================
	[	"メトロノーム記号の値を入力します。",
		"メトロノーム記号の値を入力します。",
		"Enter a value for the metronome mark.",
		"메트로놈 기호의 값을 입력합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//30以下の値を入力すると、値はクリアされ、譜面上のメトロノーム記号は消去されます。
	//================================================
	[	"30以下の値を入力すると、値はクリアされ、譜面上のメトロノーム記号は消去されます。",
		"30以下の値を入力すると、値はクリアされ、譜面上のメトロノーム記号は消去されます。",
		"If you enter a value below 30, the value will be cleared and the metronome marking will disappear from the staff.",
		"30 이하의 값을 입력하면 값이 지워지고 악보의 메트로놈 기호가 지워집니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//楽譜段数
	//================================================
	[	"楽譜段数",
		"楽譜段数",
		"Number of musical scores",
		"악보 단수",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//楽譜段数を選択します。
	//================================================
	[	"楽譜段数を選択します。",
		"楽譜段数を選択します。",
		"Select the number of music systems.",
		"악보 단수를 선택합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//楽譜段数は、最大20段まで設定できます。
	//================================================
	[	"楽譜段数は、最大20段まで設定できます。",
		"楽譜段数は、最大20段まで設定できます。",
		"The number of music scores can be set to a maximum of 20.",
		"악보단수는 최대 20단까지 설정할 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//小節数
	//================================================
	[	"小節数",
		"小節数",
		"소절수",
		"Number of measures",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//各段の小節数を選択します。
	//================================================
	[	"各段の小節数を選択します。",
		"各段の小節数を選択します。",
		"Select the number of measures per line.",
		"각 단계의 마디 수를 선택합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//各段の小節数は最大８小節まで設定できます。
	//================================================
	[	"各段の小節数は最大８小節まで設定できます。",
		"各段の小節数は最大８小節まで設定できます。",
		"The number of bars per line can be set to a maximum of 8 bars.",
		"각 단의 소절수는 최대 8 소절까지 설정할 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//６小節以上を指定すると、当初は段が画面に収まりませんが、音符や休符を設定すれば、収まります。
	//================================================
	[	"６小節以上を指定すると、当初は段が画面に収まりませんが、音符や休符を設定すれば、収まります。",
		"６小節以上を指定すると、当初は段が画面に収まりませんが、音符や休符を設定すれば、収まります。",
		"If you specify six or more measures, the line will not fit on the screen initially, but it will fit once you set notes and rests.",
		"6마디 이상을 지정하면, 당초는 단이 화면에 들어가지 않습니다만, 음표나 휴부를 설정하면, 맞습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//歌詞番数
	//================================================
	[	"歌詞番数",
		"歌詞番数",
		"Lyric number",
		"가사 번호",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//表示する歌詞番数を選択します。
	//================================================
	[	"表示する歌詞番数を選択します。",
		"表示する歌詞番数を選択します。",
		"Select the lyric number to display.",
		"표시할 가사 번호를 선택합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//歌詞番数は、「歌詞なし」「１番まで」「２番まで」「３番まで」の中から選択できます。
	//================================================
	[	"歌詞番数は、「歌詞なし」「１番まで」「２番まで」「３番まで」の中から選択できます。",
		"歌詞番数は、「歌詞なし」「１番まで」「２番まで」「３番まで」の中から選択できます。",
		"You can choose the lyric number from among \"No lyrics\", \"Up to verse 1\", \"Up to verse 2\", and \"Up to verse 3\".",
		"가사번수는, 「가사 없음」 「1번까지」 「2번까지」 「3번까지」중에서 선택할 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//歌詞の1番を入力します。
	//================================================
	[	"歌詞の1番を入力します。",
		"歌詞の1番を入力します。",
		"Enter the first verse of the lyrics.",
		"가사 1번을 입력합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//歌詞の2番を入力します。
	//================================================
	[	"歌詞の2番を入力します。",
		"歌詞の2番を入力します。",
		"Enter the second stanza of the lyrics.",
		"가사 2번을 입력합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//歌詞の3番を入力します。
	//================================================
	[	"歌詞の3番を入力します。",
		"歌詞の3番を入力します。",
		"Enter the third stanza of the lyrics.",
		"가사의 3번을 입력합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//［tab］キーの押下で、キャレットが次の番の歌詞入力へ移動します。
	//================================================
	[	"［tab］キーの押下で、キャレットが次の番の歌詞入力へ移動します。",
		"［tab］キーの押下で、キャレットが次の番の歌詞入力へ移動します。",
		"Pressing the tab key will move the caret to the next line of lyrics.",
		"[tab] 키를 누르면 캐럿이 다음 번의 가사 입력으로 이동합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//最終番での［tab］キー押下の場合は、キャレットは、楽譜上の次の音符の１番の歌詞入力へ移動します。
	//================================================
	[	"最終番での［tab］キー押下の場合は、キャレットは、楽譜上の次の音符の１番の歌詞入力へ移動します。",
		"最終番での［tab］キー押下の場合は、キャレットは、楽譜上の次の音符の１番の歌詞入力へ移動します。",
		"If you press the tab key at the last verse, the caret will move to the next note on the score, where you can enter lyrics for the first verse.",
		"마지막 번호에서 [tab] 키를 누르면 캐럿은 악보의 다음 음표 중 하나의 가사 입력으로 이동합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//小節線
	//================================================
	[	"小節線",
		"小節線",
		"Bar lines",
		"소절선",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//小節線を、次の中から選択します。
	//================================================
	[	"小節線を、次の中から選択します。",
		"小節線を、次の中から選択します。",
		"Choose from the following bar lines:",
		"소절선을 다음 중에서 선택합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//各段の先頭小節の音符や休符を選択状態で、小節線を設定すると、各段の先頭に小節線を配置できます。
	//================================================
	[	"各段の先頭小節の音符や休符を選択状態で、小節線を設定すると、各段の先頭に小節線を配置できます。",
		"各段の先頭小節の音符や休符を選択状態で、小節線を設定すると、各段の先頭に小節線を配置できます。",
		"You can place a barline at the beginning of each system by selecting the notes or rests in the first measure of each system and setting a barline.",
		"각 단의 선두 소절의 음표나 휴부를 선택 상태로 소절선을 설정하면 각 단의 선두에 소절선을 배치할 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//音符音程のアップ・ダウン
	//================================================
	[	"音符音程のアップ・ダウン",
		"音符音程のアップ・ダウン",
		"Note pitch up/down",
		"음표 음정의 업다운",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符の音程を、五線譜上で１段階、上げ下げします。
	//================================================
	[	"選択している音符の音程を、五線譜上で１段階、上げ下げします。",
		"選択している音符の音程を、五線譜上で１段階、上げ下げします。",
		"This button raises or lowers the pitch of the selected note by one notch on the staff.",
		"선택한 음표의 음정을 오선보상에서 1단계 올리고 내립니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//音程を上げます。
	//================================================
	[	"音程を上げます。",
		"音程を上げます。",
		"Increase the pitch.",
		"음정을 올립니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//音程を下げます。
	//================================================
	[	"音程を下げます。",
		"音程を下げます。",
		"Lowers the pitch.",
		"음정을 낮춥니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択中の音符の音程は、カーソル移動キー（↑、↓）やマウスドラッグでも変更できます。
	//================================================
	[	"選択中の音符の音程は、カーソル移動キー（↑、↓）やマウスドラッグでも変更できます。",
		"選択中の音符の音程は、カーソル移動キー（↑、↓）やマウスドラッグでも変更できます。",
		"The pitch of the selected note can also be changed using the cursor keys (↑, ↓) or by dragging the mouse.",
		"선택한 음표의 음정은 커서 이동 키(↑, ↓)나 마우스 드래그로 변경할 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//和音と三連符の左端の音符の音階は変更できません。
	//================================================
	[	"和音と三連符の左端の音符の音階は変更できません。",
		"和音と三連符の左端の音符の音階は変更できません。",
		"The leftmost note of chords and triplets cannot be changed.",
		"화음과 삼연부의 가장 왼쪽 음표의 음계는 변경할 수 없습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//和音の音階の変更は、和音設定ボタン
	//================================================
	[	"和音の音階の変更は、和音設定ボタン",
		"和音の音階の変更は、和音設定ボタン",
		"To change the scale of a chord, use the Chord Setting button",
		"화음의 음계의 변경은, 화음 설정 버튼",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//から行ってください。
	//================================================
	[	"から行ってください。",
		"から行ってください。",
		".",
		"에서 실시해 주세요.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//三連符の左端の音符の音階の変更は、一旦、三連符を解除してから行ってください。
	//================================================
	[	"三連符の左端の音符の音階の変更は、一旦、三連符を解除してから行ってください。",
		"三連符の左端の音符の音階の変更は、一旦、三連符を解除してから行ってください。",
		"To change the scale of the leftmost note of a triplet, you must first cancel the triplet.",
		"삼연부의 좌단의 음표의 음계의 변경은, 일단, 삼연부를 해제하고 나서 실시해 주세요.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//（注）カーソル移動キーでの音程変更時は、音程変更後に［Enter］キーを押下して、音程を決定する必要があります。
	//================================================
	[	"（注）カーソル移動キーでの音程変更時は、音程変更後に［Enter］キーを押下して、音程を決定する必要があります。",
		"（注）カーソル移動キーでの音程変更時は、音程変更後に［Enter］キーを押下して、音程を決定する必要があります。",
		"(Note) When changing the pitch using the cursor keys, you must press the [Enter] key after changing the pitch to confirm the change.",
		"(주) 커서 이동 키로 음정을 변경할 때는 음정 변경 후에 [Enter] 키를 눌러 음정을 결정해야 합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//（注）マウスドラッグでの音程変更時に、アンプの位置が定まらない場合があります。この場合は、上記のボタン操作やカーソル移動キー（↑、↓）の操作によって、音程を調整してください。
	//================================================
	[	"（注）マウスドラッグでの音程変更時に、アンプの位置が定まらない場合があります。この場合は、上記のボタン操作やカーソル移動キー（↑、↓）の操作によって、音程を調整してください。",
		"（注）マウスドラッグでの音程変更時に、アンプの位置が定まらない場合があります。この場合は、上記のボタン操作やカーソル移動キー（↑、↓）の操作によって、音程を調整してください。",
		"(Note) When changing the pitch by dragging the mouse, the amplifier position may not be fixed. In this case, adjust the pitch by using the buttons or cursor movement keys (↑, ↓) as described above.",
		"(주) 마우스 드래그로 음정을 변경할 때 앰프의 위치가 정해지지 않는 경우가 있습니다. 이 경우 위의 버튼 조작이나 커서 이동 키(↑, ↓)의 조작에 의해 음정을 조정하십시오.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//音符・休符の配置
	//================================================
	[	"音符・休符の配置",
		"音符・休符の配置",
		"Positioning of notes and rests",
		"음표·휴부 배치",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符や休符の位置に、クリックした音符や休符を配置にます。
	//================================================
	[	"選択している音符や休符の位置に、クリックした音符や休符を配置にます。",
		"選択している音符や休符の位置に、クリックした音符や休符を配置にます。",
		"The note or rest you click will be placed at the position of the selected note or rest.",
		"선택한 음표나 휴지점 위치에 클릭한 음표나 휴지통을 배치합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//配置できる音符は、次の音符の内の、小節内に収まる恩寵の音符で、余剰分は、小節の全体音調を満たすために必要な音長の音符や休符<sup>（※）</sup>となります。
	//================================================
	[	"配置できる音符は、次の音符の内の、小節内に収まる恩寵の音符で、余剰分は、小節の全体音調を満たすために必要な音長の音符や休符<sup>（※）</sup>となります。",
		"配置できる音符は、次の音符の内の、小節内に収まる恩寵の音符で、余剰分は、小節の全体音調を満たすために必要な音長の音符や休符<sup>（※）</sup>となります。",
		"The notes that can be placed are the grace notes among the following notes that fit within the measure, and the surplus notes will be notes or rests of the necessary duration to complete the overall tone of the measure <sup>(※)</sup>.",
		"배치할 수 있는 음표는, 다음의 음표 안의, 소절내에 들어가는 은총의 음표로, 잉여분은, 소절의 전체 음조를 채우기 위해서 필요한 음장의 음표나 휴부<sup>(※)</sup>입니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//また、［その他の音符・休符］ボタン&nbsp;<img class="btnCommand" src="../imgMSC/moreArticulation.png">&nbsp;を押下することで、次の音調の音符を配置することができます。
	//================================================
	[	"また、［その他の音符・休符］ボタン&nbsp;<img class='btnCommand' src='../imgMSC/moreArticulation.png'>&nbsp;を押下することで、次の音調の音符を配置することができます。",
		"また、［その他の音符・休符］ボタン&nbsp;<img class='btnCommand' src='../imgMSC/moreArticulation.png'>&nbsp;を押下することで、次の音調の音符を配置することができます。",
		"You can also place notes of the next key by pressing the [More Notes/Rests] button&nbsp;<img class='btnCommand' src='../imgMSC/moreArticulation.png'>.",
		"또, [기타 음표·휴부] 버튼&nbsp;<img class='btnCommand' src='../imgMSC/moreArticulation.png'>&nbsp;를 눌러서 다음 음조의 음표를 배치하는 것 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//配置できる休符は、次の休符の内の、小節内に収まる恩寵の休符で、余剰分は、小節の全体音調を満たすために必要な音長の音符や休符<sup>（※）</sup>となります。
	//================================================
	[	"配置できる休符は、次の休符の内の、小節内に収まる恩寵の休符で、余剰分は、小節の全体音調を満たすために必要な音長の音符や休符<sup>（※）</sup>となります。",
		"配置できる休符は、次の休符の内の、小節内に収まる恩寵の休符で、余剰分は、小節の全体音調を満たすために必要な音長の音符や休符<sup>（※）</sup>となります。",
		"The rests that can be placed are grace rests among the following rests that fit within the measure, and any surplus rests will be notes or rests of the necessary duration to complete the overall tone of the measure <sup>(※)</sup>.",
		"배치할 수 있는 휴부는, 다음의 휴부 중의, 소절내에 들어가는 은총의 휴부로, 잉여분은, 소절의 전체 음조를 채우기 위해서 필요한 음장의 음표나 휴부<sup>(※ )</sup>입니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//また、［その他の音符・休符］ボタン&nbsp;<img class='btnCommand' src='../imgMSC/moreArticulation.png'>&nbsp;を押下することで、次の音調の音符を配置することができます。
	//================================================
	[	"また、［その他の音符・休符］ボタン&nbsp;<img class='btnCommand' src='../imgMSC/moreArticulation.png'>&nbsp;を押下することで、次の音調の音符を配置することができます。",
		"また、［その他の音符・休符］ボタン&nbsp;<img class='btnCommand' src='../imgMSC/moreArticulation.png'>&nbsp;を押下することで、次の音調の音符を配置することができます。",
		"You can also place notes of the next key by pressing the [More Notes and Rests] button <img class='btnCommand' src='../imgMSC/moreArticulation.png'>.",
		"또, [기타 음표·휴부] 버튼&nbsp;<img class='btnCommand' src='../imgMSC/moreArticulation.png'>&nbsp;를 누르는 것으로, 다음의 음조의 음표를 배치하는 것 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//※『小節の全体音調を満たすために必要な音長の音符や休符』とは、
	//================================================
	[	"※『小節の全体音調を満たすために必要な音長の音符や休符』とは、",
		"※『小節の全体音調を満たすために必要な音長の音符や休符』とは、",
		"*The term \"notes and rests of the necessary length to satisfy the overall tone of the measure\" refers to",
		"※「소절의 전체 음조를 채우기 위해서 필요한 음장의 음표나 휴부」란,",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//例えば、<math xmlns="http://www.w3.org/1998/Math/MathML"><mfrac><mn>4</mn><mn>4</mn></mfrac></math>拍子で、次のように小節の最後に配置された４分音符を選択した状態で、
	//================================================
	[	"例えば、<math xmlns='http://www.w3.org/1998/Math/MathML'><mfrac><mn>4</mn><mn>4</mn></mfrac></math>拍子で、次のように小節の最後に配置された４分音符を選択した状態で、",
		"例えば、<math xmlns='http://www.w3.org/1998/Math/MathML'><mfrac><mn>4</mn><mn>4</mn></mfrac></math>拍子で、次のように小節の最後に配置された４分音符を選択した状態で、",
		"For example, in a <math xmlns='http://www.w3.org/1998/Math/MathML'><mfrac><mn>4</mn><mn>4</mn></mfrac></math> time signature, with a quarter note at the end of the measure selected as shown below,",
		"예를 들어, <math xmlns='http://www.w3.org/1998/Math/MathML'><mfrac><mn>4</mn><mn>4</mn></mfrac></math >박자로, 다음과 같이 소절의 마지막에 배치된 4분 음표를 선택한 상태에서,",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//８分音符ボタン<img class='btnCommand' src='../imgMSC/note8_22.png'>を押下すると、４分音符に変えて、８分音符を４分音符を配置し、小節内の音長を調整します。
	//================================================
	[	"８分音符ボタン<img class='btnCommand' src='../imgMSC/note8_22.png'>を押下すると、４分音符に変えて、８分音符を４分音符を配置し、小節内の音長を調整します。",
		"８分音符ボタン<img class='btnCommand' src='../imgMSC/note8_22.png'>を押下すると、４分音符に変えて、８分音符を４分音符を配置し、小節内の音長を調整します。",
		"Pressing the eighth note button <img class='btnCommand' src='../imgMSC/note8_22.png'> will change the notes to quarter notes, placing the eighth notes as quarter notes and adjusting the note length within the measure.",
		"8분 음표 버튼 <img class='btnCommand' src='../imgMSC/note8_22.png'>을 누르면 4분 음표로 바꾸고 8분 음표를 4분 음표를 배치하고 소절 내의 소리 길이를 조정합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//臨時記号の配置・削除
	//================================================
	[	"臨時記号の配置・削除",
		"臨時記号の配置・削除",
		"Placing and removing accidentals",
		"임시 기호의 배치·삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符に、臨時記号（♯、♭、♮）を設定したり、削除したりします。
	//================================================
	[	"選択している音符に、臨時記号（♯、♭、♮）を設定したり、削除したりします。",
		"選択している音符に、臨時記号（♯、♭、♮）を設定したり、削除したりします。",
		"Adds or removes an accidental (♯, ♭, ♮) to the selected note.",
		"선택한 음표에 임시 기호(♯, ♭, ♮)를 설정하거나 삭제합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//シャープ（♯）を配置
	//================================================
	[	"シャープ（♯）を配置",
		"シャープ（♯）を配置",
		"Place a sharp (♯)",
		"샤프(♯) 배치",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//フラット（♭）を配置
	//================================================
	[	"フラット（♭）を配置",
		"フラット（♭）を配置",
		"Placing a flat (♭)",
		"플랫(♭) 배치",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//ナチュラル（♮）を配置
	//================================================
	[	"ナチュラル（♮）を配置",
		"ナチュラル（♮）を配置",
		"Place a natural (♮)",
		"자연(♮) 배치",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//臨時記号（♯、♭、♮）を削除
	//================================================
	[	"臨時記号（♯、♭、♮）を削除",
		"臨時記号（♯、♭、♮）を削除",
		"Remove accidentals (♯, ♭, ♮)",
		"임시 기호(♯, ♭, ♮) 삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//和音の個々の音符に臨時記号（♯、♭、♮）を配置する場合は、和音設定ボタン&nbsp;<img class='btnCommand' src='../imgMSC/note_plus.png'>&nbsp;から行ってください。
	//================================================
	[	"和音の個々の音符に臨時記号（♯、♭、♮）を配置する場合は、和音設定ボタン&nbsp;<img class='btnCommand' src='../imgMSC/note_plus.png'>&nbsp;から行ってください。",
		"和音の個々の音符に臨時記号（♯、♭、♮）を配置する場合は、和音設定ボタン&nbsp;<img class='btnCommand' src='../imgMSC/note_plus.png'>&nbsp;から行ってください。",
		"If you want to place accidentals (♯, ♭, ♮) on individual notes of a chord, you can do so from the Chord Settings button <img class='btnCommand' src='../imgMSC/note_plus.png'>.",
		"화음의 개별 음표에 임시 기호(♯, ♭, ♮)를 배치하려면 화음 설정 버튼 &nbsp;<img class='btnCommand' src='../imgMSC/note_plus.png'>&nbsp; 제발.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//タイとスラーの配置・削除
	//================================================
	[	"タイとスラーの配置・削除",
		"タイとスラーの配置・削除",
		"Placing and removing ties and slurs",
		"태국과 슬러의 배치 및 삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符を起点や終点とするタイやスラーを設定したり、削除したりします。
	//================================================
	[	"選択している音符を起点や終点とするタイやスラーを設定したり、削除したりします。",
		"選択している音符を起点や終点とするタイやスラーを設定したり、削除したりします。",
		"Adds or removes a tie or slur whose start or end point is the selected note.",
		"선택한 음표를 기점이나 종점으로 하는 타이나 슬러를 설정하거나 삭제합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//１度目のクリック：選択した音符と右隣りの音符の間にタイを設定します。
	//================================================
	[	"１度目のクリック：選択した音符と右隣りの音符の間にタイを設定します。",
		"１度目のクリック：選択した音符と右隣りの音符の間にタイを設定します。",
		"First click：Creates a tie between the selected note and the adjacent note to the right.",
		"첫 번째 클릭：선택한 음표와 오른쪽 옆의 음표 사이에 타이를 설정합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択中の音符の音階と右隣りの音符の音階が異なる場合は、譜面上は２音間にスラーが表示されますが、演奏上はスラーとはならないので注意してください。
	//================================================
	[	"選択中の音符の音階と右隣りの音符の音階が異なる場合は、譜面上は２音間にスラーが表示されますが、演奏上はスラーとはならないので注意してください。",
		"選択中の音符の音階と右隣りの音符の音階が異なる場合は、譜面上は２音間にスラーが表示されますが、演奏上はスラーとはならないので注意してください。",
		"If the scale of the selected note is different from the scale of the note to the right, a slur will be displayed between the two notes on the staff, but please note that it will not be a slur when played.",
		"선택중인 음표의 음계와 오른쪽 옆의 음표의 음계가 다른 경우는, 보면상은 2음 사이에 슬러가 표시됩니다만, 연주상은 슬러가 되지 않으므로 주의해 주세요.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//２度目のクリック：選択した音符にスラーの起点を設定します。
	//================================================
	[	"２度目のクリック：選択した音符にスラーの起点を設定します。",
		"２度目のクリック：選択した音符にスラーの起点を設定します。",
		"Second click：Sets the slur start point on the selected note.",
		"두 번째 클릭：선택한 음표에 슬러의 기점을 설정합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択中の音符から、楽譜の最終段の最終小節の間にかけてスラーが表示されるので、必ずスラーの終点を指定してください。
	//================================================
	[	"選択中の音符から、楽譜の最終段の最終小節の間にかけてスラーが表示されるので、必ずスラーの終点を指定してください。",
		"選択中の音符から、楽譜の最終段の最終小節の間にかけてスラーが表示されるので、必ずスラーの終点を指定してください。",
		"The slur will appear from the selected note to the last measure of the last system of the score, so be sure to specify the end point of the slur.",
		"선택한 음표에서 악보의 마지막 단의 마지막 마디 사이에 걸쳐 슬러가 표시되므로 반드시 슬러의 끝점을 지정하십시오.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符にスラーの終点を設定します。
	//================================================
	[	"選択している音符にスラーの終点を設定します。",
		"選択している音符にスラーの終点を設定します。",
		"Sets the slur end point to the selected note.",
		"선택한 음표에 슬러의 끝점을 설정합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符に設定されているタイまたはスラーの始点を削除します。
	//================================================
	[	"選択している音符に設定されているタイまたはスラーの始点を削除します。",
		"選択している音符に設定されているタイまたはスラーの始点を削除します。",
		"Removes the start point of a tie or slur from the selected note.",
		"선택한 음표에 설정된 태국 또는 슬러의 시작점을 삭제합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符にタイとスラーの始点の両方が設定されている場合は、タイを削除します。
	//================================================
	[	"選択している音符にタイとスラーの始点の両方が設定されている場合は、タイを削除します。",
		"選択している音符にタイとスラーの始点の両方が設定されている場合は、タイを削除します。",
		"If the selected note contains both a tie and a slur start point, the tie will be removed.",
		"선택한 음표에 타이와 슬러의 시작점이 모두 설정되어 있으면 타이를 삭제합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符に設定されているスラーの終点を削除します。
	//================================================
	[	"選択している音符に設定されているスラーの終点を削除します。",
		"選択している音符に設定されているスラーの終点を削除します。",
		"Removes the end of the slur from the selected note.",
		"선택한 음표에 설정된 슬러의 끝점을 삭제합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//ブレスの配置・削除
	//================================================
	[	"ブレスの配置・削除",
		"ブレスの配置・削除",
		"Placing and deleting breaths",
		"브레스 배치/삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している小節線上や、選択している音符と右隣りの音符の間に、ブレス記号（V）を配置したり、削除したりします。
	//================================================
	[	"選択している小節線上や、選択している音符と右隣りの音符の間に、ブレス記号（V）を配置したり、削除したりします。",
		"選択している小節線上や、選択している音符と右隣りの音符の間に、ブレス記号（V）を配置したり、削除したりします。",
		"This command adds or removes a breath sign (V) on the selected barline, or between the selected note and the adjacent note to the right.",
		"선택한 소절 선이나 선택한 음표와 오른쪽 이웃 음표 사이에 브레스 기호(V)를 배치하거나 삭제합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//ブレス記号を配置
	//================================================
	[	"ブレス記号を配置",
		"ブレス記号を配置",
		"Place a breath mark",
		"브레스 기호 배치",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//ブレス記号を削除
	//================================================
	[	"ブレス記号を削除",
		"ブレス記号を削除",
		"Remove breath mark",
		"브레스 기호 삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//アーティキュレーション記号の配置・削除
	//================================================
	[	"アーティキュレーション記号の配置・削除",
		"アーティキュレーション記号の配置・削除",
		"Adding and Removing Articulations",
		"아티큘레이션 기호 배치/삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符上に、アーティキュレーション記号を配置したり、削除したりします。
	//================================================
	[	"選択している音符上に、アーティキュレーション記号を配置したり、削除したりします。",
		"選択している音符上に、アーティキュレーション記号を配置したり、削除したりします。",
		"Allows you to place or remove articulations on the selected notes.",
		"선택한 음표에 아티큘레이션 기호를 배치하거나 삭제합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//配置できるアーティキュレーション記号は、
	//================================================
	[	"配置できるアーティキュレーション記号は、",
		"配置できるアーティキュレーション記号は、",
		"Articulation symbols that can be placed are:",
		"배치할 수 있는 아티큘레이션 기호는,",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//（アクセント）以外のアーティキュレーション記号は、
	//================================================
	[	"<img class='btnCommand' src='../imgMSC/accentH.png'>（アクセント）以外のアーティキュレーション記号は、",
		"<img class='btnCommand' src='../imgMSC/accentH.png'>（アクセント）以外のアーティキュレーション記号は、",
		"<img class='btnCommand' src='../imgMSC/accentH.png'> Articulation symbols other than (accent) are",
		"<img class='btnCommand' src='../imgMSC/accentH.png'>(악센트) 이외의 아티큘레이션 기호는",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//［その他のアーティキュレーション］ボタン&nbsp;<img class='btnCommand' src='../imgMSC/moreArticulation.png'>&nbsp;を押下することで表示される、オプションメニューから配置できます。
	//================================================
	[	"［その他のアーティキュレーション］ボタン&nbsp;<img class='btnCommand' src='../imgMSC/moreArticulation.png'>&nbsp;を押下することで表示される、オプションメニューから配置できます。",
		"［その他のアーティキュレーション］ボタン&nbsp;<img class='btnCommand' src='../imgMSC/moreArticulation.png'>&nbsp;を押下することで表示される、オプションメニューから配置できます。",
		"You can place it from the options menu that appears when you press the [More Articulations] button <img class='btnCommand' src='../imgMSC/moreArticulation.png'>.",
		"기타 아티큘레이션 버튼 &nbsp;<img class='btnCommand' src='../imgMSC/moreArticulation.png'>&nbsp;를 눌러 표시되는 옵션 메뉴에서 배치할 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//配置済みのアーティキュレーション記号の削除は、<img class='btnCommand' src='../imgMSC/noArticulation.png'>&nbsp;ボタンで行います。
	//================================================
	[	"配置済みのアーティキュレーション記号の削除は、<img class='btnCommand' src='../imgMSC/noArticulation.png'>&nbsp;ボタンで行います。",
		"配置済みのアーティキュレーション記号の削除は、<img class='btnCommand' src='../imgMSC/noArticulation.png'>&nbsp;ボタンで行います。",
		"To delete an articulation symbol that has already been placed, use the <img class='btnCommand' src='../imgMSC/noArticulation.png'>&nbsp;button.",
		"배치된 아티큘레이션 기호의 삭제는, <img class='btnCommand' src='../imgMSC/noArticulation.png'>&nbsp; 버튼으로 실시합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//<img class='btnCommand' src='../imgMSC/noArticulation.png'>&nbsp;ボタンをクリックすると、選択中の音符に設定されているすべてのアーティキュレーションが削除されます。
	//================================================
	[	"<img class='btnCommand' src='../imgMSC/noArticulation.png'>&nbsp;ボタンをクリックすると、選択中の音符に設定されているすべてのアーティキュレーションが削除されます。",
		"<img class='btnCommand' src='../imgMSC/noArticulation.png'>&nbsp;ボタンをクリックすると、選択中の音符に設定されているすべてのアーティキュレーションが削除されます。",
		"<img class='btnCommand' src='../imgMSC/noArticulation.png'>Clicking this button will remove all articulations from the selected notes.",
		"<img class='btnCommand' src='../imgMSC/noArticulation.png'>&nbsp; 버튼을 클릭하면 선택한 음표에 설정된 모든 아티큘레이션이 삭제됩니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//（注）１つの音符に対して、複数のアーティキュレーション記号を配置できますが、削除は、一括削除のみとなる点に注意してください。
	//================================================
	[	"（注）１つの音符に対して、複数のアーティキュレーション記号を配置できますが、削除は、一括削除のみとなる点に注意してください。",
		"（注）１つの音符に対して、複数のアーティキュレーション記号を配置できますが、削除は、一括削除のみとなる点に注意してください。",
		"(Note) You can place multiple articulation symbols on one note, but please note that you can only delete them all at once.",
		"참고 하나의 음표에 대해 여러 개의 아티큘레이션 기호를 배치 할 수 있지만 삭제는 일괄 삭제 만된다는 점에주의하십시오.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//和音の配置・削除
	//================================================
	[	"和音の配置・削除",
		"和音の配置・削除",
		"Placing and deleting chords",
		"화음의 배치・삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符に、和音を設定したり、削除したりします。
	//================================================
	[	"選択している音符に、和音を設定したり、削除したりします。",
		"選択している音符に、和音を設定したり、削除したりします。",
		"This allows you to add or remove chords to the selected notes.",
		"선택한 음표에 화음을 설정하거나 삭제합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//和音の設定
	//================================================
	[	"和音の設定",
		"和音の設定",
		"Chord Settings",
		"화음 설정",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//和音設定ダイアログが表示されるので、和音や臨時記号を設定し、［OK］ボタンをクリックして下さい。
	//================================================
	[	"和音設定ダイアログが表示されるので、和音や臨時記号を設定し、［OK］ボタンをクリックして下さい。",
		"和音設定ダイアログが表示されるので、和音や臨時記号を設定し、［OK］ボタンをクリックして下さい。",
		"The chord setting dialog will appear, so set the chords and accidentals and click the [OK] button.",
		"화음 설정 대화 상자가 표시되므로 화음이나 임시 기호를 설정하고 [OK] 버튼을 클릭하십시오.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//和音の削除
	//================================================
	[	"和音の削除",
		"和音の削除",
		"Delete chord",
		"화음 삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//設定済みの和音の最も高い音階の音符を残して、和音を削除します。
	//================================================
	[	"設定済みの和音の最も高い音階の音符を残して、和音を削除します。",
		"設定済みの和音の最も高い音階の音符を残して、和音を削除します。",
		"This will remove the chords, leaving only the highest scale note of the chord you have set.",
		"설정된 화음의 가장 높은 음계의 음표를 남겨 화음을 삭제합니다.설정된 화음의 가장 높은 음계의 음표를 남겨 화음을 삭제합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//（注）和音を設定した音符は、音階のアップ・ダウンボタン（<img class='btnCommand' src='../imgMSC/note_up.png'>、<img class='btnCommand' src='../imgMSC/note_down.png'>）やドラッグ等による音階の変更はできません。
	//================================================
	[	"（注）和音を設定した音符は、音階のアップ・ダウンボタン（<img class='btnCommand' src='../imgMSC/note_up.png'>、<img class='btnCommand' src='../imgMSC/note_down.png'>）やドラッグ等による音階の変更はできません。",
		"（注）和音を設定した音符は、音階のアップ・ダウンボタン（<img class='btnCommand' src='../imgMSC/note_up.png'>、<img class='btnCommand' src='../imgMSC/note_down.png'>）やドラッグ等による音階の変更はできません。",
		"(Note) If a chord has been set for a note, you cannot change the scale using the scale up/down buttons (<img class='btnCommand' src='../imgMSC/note_up.png'>, <img class='btnCommand' src='../imgMSC/note_down.png'>) or by dragging.",
		"참고 화음을 설정한 음표는 음계의 업다운 버튼(<img class='btnCommand' src='../imgMSC/note_up.png'>, <img class='btnCommand' src='.. /imgMSC/note_down.png'>)나 드래그 등에 의한 음계의 변경은 할 수 없습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//８分音符等の分離・結合
	//================================================
	[	"８分音符等の分離・結合",
		"８分音符等の分離・結合",
		"Separation and joining of eighth notes etc.",
		"8분 음표 등의 분리·결합",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している８分音符等を、右隣りの８分音符等と分離したり、結合したりします。
	//================================================
	[	"選択している８分音符等を、右隣りの８分音符等と分離したり、結合したりします。",
		"選択している８分音符等を、右隣りの８分音符等と分離したり、結合したりします。",
		"This separates or joins the selected eighth note etc. to the adjacent eighth note etc. to the right.",
		"선택한 8분 음표 등을 오른쪽 옆의 8분 음표 등과 분리하거나 결합합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//右隣りの８分音符等と分離します。
	//================================================
	[	"右隣りの８分音符等と分離します。",
		"右隣りの８分音符等と分離します。",
		"It is separated from the eighth note to the right, etc.",
		"오른쪽 옆의 8분 음표 등과 분리합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//右隣りの８分音符等と結合します。
	//================================================
	[	"右隣りの８分音符等と結合します。",
		"右隣りの８分音符等と結合します。",
		"It will combine with the eighth note to the right, etc.",
		"오른쪽 옆의 8분 음표 등과 결합합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//３連符の設定・解除
	//================================================
	[	"３連符の設定・解除",
		"３連符の設定・解除",
		"Setting/Removing Triplets",
		"3연부의 설정·해제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符を、３連符としたり、３連符を解除したりします。
	//================================================
	[	"選択している音符を、３連符としたり、３連符を解除したりします。",
		"選択している音符を、３連符としたり、３連符を解除したりします。",
		"This will turn the selected notes into or out of a triplet.",
		"선택한 음표를 3연부로 하거나 3연부를 해제하거나 합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//３連符にします。
	//================================================
	[	"３連符にします。",
		"３連符にします。",
		"Make it a triplet.",
		"3연부로 합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//３連符を解除します。
	//================================================
	[	"３連符を解除します。",
		"３連符を解除します。",
		"Release the triplet.",
		"3연부를 해제합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//（注）３連符の左端の音符は、音階のアップ・ダウンボタン（<img class='btnCommand' src='../imgMSC/note_up.png'>、<img class='btnCommand' src='../imgMSC/note_down.png'>）やドラッグ等による音階の変更はできません。
	//================================================
	[	"（注）３連符の左端の音符は、音階のアップ・ダウンボタン（<img class='btnCommand' src='../imgMSC/note_up.png'>、<img class='btnCommand' src='../imgMSC/note_down.png'>）やドラッグ等による音階の変更はできません。",
		"（注）３連符の左端の音符は、音階のアップ・ダウンボタン（<img class='btnCommand' src='../imgMSC/note_up.png'>、<img class='btnCommand' src='../imgMSC/note_down.png'>）やドラッグ等による音階の変更はできません。",
		"(Note) The scale of the leftmost note in a triplet cannot be changed using the scale up/down buttons (<img class='btnCommand' src='../imgMSC/note_up.png'>, <img class='btnCommand' src='../imgMSC/note_down.png'>) or by dragging.",
		"(주) 3연부의 좌단의 음표는, 음계의 업·다운 버튼(<img class='btnCommand' src='../imgMSC/note_up.png'>, <img class='btnCommand' src=' ../imgMSC/note_down.png'>)나 드래그 등에 의한 음계의 변경은 할 수 없습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符の位置に強弱記号を配置します。
	//================================================
	[	"選択している音符の位置に強弱記号を配置します。",
		"選択している音符の位置に強弱記号を配置します。",
		"Places a dynamic symbol at the position of the selected note.",
		"선택한 음표 위치에 강약 기호를 배치합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//次の強弱記号を配置できます。
	//================================================
	[	"次の強弱記号を配置できます。",
		"次の強弱記号を配置できます。",
		"The following dynamics can be placed:",
		"다음 강약 기호를 배치할 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//強弱なし
	//================================================
	[	"強弱なし",
		"強弱なし",
		"No intensity",
		"강약 없음",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//<span class='bravura'>&#xE53E;</span>&nbsp;と&nbsp;<span class='bravura'>&#xE53F;</span>&nbsp;の配置に当たっては、始点となる音符と、終点となる音符を指定する必要があります。
	//================================================
	[	"<span class='bravura'>&#xE53E;</span>&nbsp;と&nbsp;<span class='bravura'>&#xE53F;</span>&nbsp;の配置に当たっては、始点となる音符と、終点となる音符を指定する必要があります。",
		"<span class='bravura'>&#xE53E;</span>&nbsp;と&nbsp;<span class='bravura'>&#xE53F;</span>&nbsp;の配置に当たっては、始点となる音符と、終点となる音符を指定する必要があります。",
		"When placing <span class='bravura'>&#xE53E;</span>&nbsp; and &nbsp;<span class='bravura'>&#xE53F;</span>&nbsp;, you need to specify the start note and the end note.",
		"<span class='bravura'>&#xE53E;</span>&nbsp; 및 &nbsp;<span class='bravura'>&#xE53F;</span>&nbsp; 종점이 될 음표를 지정해야 합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//（注）<span class='bravura'>&#xE53E;</span>&nbsp;と&nbsp;<span class='bravura'>&#xE53F;</span>&nbsp;の、始点と終点は、段をまたいで指定することはできません。
	//================================================
	[	"（注）<span class='bravura'>&#xE53E;</span>&nbsp;と&nbsp;<span class='bravura'>&#xE53F;</span>&nbsp;の、始点と終点は、段をまたいで指定することはできません。",
		"（注）<span class='bravura'>&#xE53E;</span>&nbsp;と&nbsp;<span class='bravura'>&#xE53F;</span>&nbsp;の、始点と終点は、段をまたいで指定することはできません。",
		"(Note) The start and end points of <span class='bravura'>&#xE53E;</span>&nbsp; and <span class='bravura'>&#xE53F;</span>&nbsp; cannot be specified across columns.",
		"참고 <span class='bravura'>&#xE53E;</span>&nbsp; 및 &nbsp;<span class='bravura'>&#xE53F;</span>&nbsp;의 시작점과 끝점은 를 통해 지정할 수 없습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符や小節線の位置に反復記号を配置します。
	//================================================
	[	"選択している音符や小節線の位置に反復記号を配置します。",
		"選択している音符や小節線の位置に反復記号を配置します。",
		"Places a repeat symbol at the selected note or barline.",
		"선택한 음표나 소절선의 위치에 반복 기호를 배치합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//次の反復記号を配置できます。
	//================================================
	[	"次の反復記号を配置できます。",
		"次の反復記号を配置できます。",
		"The following repeat symbols can be placed:",
		"다음 반복 기호를 배치할 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//反復なし
	//================================================
	[	"反復なし",
		"反復なし",
		"No repetition",
		"반복 없음",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//Undo、Redo
	//================================================
	[	"Undo、Redo",
		"Undo、Redo",
		"Undo、Redo",
		"Undo、Redo",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//直前の操作を取り消したり、取り消した操作を戻したりします。
	//================================================
	[	"直前の操作を取り消したり、取り消した操作を戻したりします。",
		"直前の操作を取り消したり、取り消した操作を戻したりします。",
		"Undoes the most recent action or reverses an action that has been undone.",
		"이전 조작을 취소하거나 취소된 조작을 리턴합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//直前の操作を取り消します。
	//================================================
	[	"直前の操作を取り消します。",
		"直前の操作を取り消します。",
		"Undoes the last action.",
		"이전 작업을 취소합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//取り消した操作を戻します。
	//================================================
	[	"取り消した操作を戻します。",
		"取り消した操作を戻します。",
		"Reverses an undone action.",
		"취소된 조작을 리턴합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//譜面の初期化
	//================================================
	[	"譜面の初期化",
		"譜面の初期化",
		"Initializing the score",
		"악보 초기화",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//現在の編集内容を破棄して、譜面を初期化します。
	//================================================
	[	"現在の編集内容を破棄して、譜面を初期化します。",
		"現在の編集内容を破棄して、譜面を初期化します。",
		"Discard the current edited content and initialize the musical score.",
		"현재 편집 내용을 삭제하고 악보를 초기화합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//<img class='btnCommand' src='../imgMSC/new22.png'>&nbsp;をクリックすると確認ダイアログが表示されます。
	//================================================
	[	"<img class='btnCommand' src='../imgMSC/new22.png'>&nbsp;をクリックすると確認ダイアログが表示されます。",
		"<img class='btnCommand' src='../imgMSC/new22.png'>&nbsp;をクリックすると確認ダイアログが表示されます。",
		"Clicking <img class='btnCommand' src='../imgMSC/new22.png'> will display a confirmation dialog.",
		"<img class='btnCommand' src='../imgMSC/new22.png'>&nbsp;를 클릭하면 확인 대화 상자가 표시됩니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//［はい］ボタンをクリックすることで、譜面を初期化できます。
	//================================================
	[	"［はい］ボタンをクリックすることで、譜面を初期化できます。",
		"［はい］ボタンをクリックすることで、譜面を初期化できます。",
		"You can initialize the score by clicking the [Yes] button.",
		"[예] 버튼을 클릭하여 악보를 초기화할 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//譜面を開く
	//================================================
	[	"譜面を開く",
		"譜面を開く",
		"Open the score",
		"악보 열기",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//現在の編集内容を破棄して、ファイルから譜面データを読込みます。
	//================================================
	[	"現在の編集内容を破棄して、ファイルから譜面データを読込みます。",
		"現在の編集内容を破棄して、ファイルから譜面データを読込みます。",
		"Discard the current edits and load the music score data from the file.",
		"현재 편집 내용을 삭제하고 파일에서 악보 데이터를 읽습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//<img class='btnCommand' src='../imgMSC/open22.png'>&nbsp;をクリックするとファイルOpenダイアログが表示されます。
	//================================================
	[	"<img class='btnCommand' src='../imgMSC/open22.png'>&nbsp;をクリックするとファイルOpenダイアログが表示されます。",
		"<img class='btnCommand' src='../imgMSC/open22.png'>&nbsp;をクリックするとファイルOpenダイアログが表示されます。",
		"Clicking <img class='btnCommand' src='../imgMSC/open22.png'> will display the file Open dialog.",
		"<img class='btnCommand' src='../imgMSC/open22.png'>&nbsp;를 클릭하면 파일 열기 대화상자가 표시됩니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//読み込む楽譜ファイル（拡張子：.msd）を指定して、［開く］ボタンをクリックすることで、譜面データを開くことができます。
	//================================================
	[	"読み込む楽譜ファイル（拡張子：.msd）を指定して、［開く］ボタンをクリックすることで、譜面データを開くことができます。",
		"読み込む楽譜ファイル（拡張子：.msd）を指定して、［開く］ボタンをクリックすることで、譜面データを開くことができます。",
		"You can open the music score data by specifying the music score file (extension: .msd) you want to load and clicking the [Open] button.",
		"로드할 악보 파일(확장자: .msd)을 지정하고 [열기] 버튼을 클릭하여 악보 데이터를 열 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//<a href='../sample/' target='_blank'><b><u><b>MSC-Editor用 サンプル楽曲データのダウンロードページ</b></u></b></a>
	//================================================
	[	"<a href='../sample/' target='_blank'><b><u><b>MSC-Editor用 サンプル楽曲データのダウンロードページ</b></u></b></a>",
		"<a href='../sample/' target='_blank'><b><u><b>MSC-Editor用 サンプル楽曲データのダウンロードページ</b></u></b></a>",
		"<a href='../sample/' target='_blank'><b><u><b>Download page for sample music data for MSC-Editor</b></u></b></a>（Japanese only）",
		"<a href='../sample/' target='_blank'><b><u><b>MSC-Editor용 샘플 곡 데이터 다운로드 페이지</b></u></b></a>（일본어만）",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//譜面の保存
	//================================================
	[	"譜面の保存",
		"譜面の保存",
		"Saving the score",
		"악보 저장",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//現在の編集内容をファイルに保存します。
	//================================================
	[	"現在の編集内容をファイルに保存します。",
		"現在の編集内容をファイルに保存します。",
		"Saves the current edits to a file.",
		"현재 편집 내용을 파일에 저장합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//<img class='btnCommand' src='../imgMSC/save22.png'>&nbsp;をクリックするとファイルSaveダイアログが表示されます。
	//================================================
	[	"<img class='btnCommand' src='../imgMSC/save22.png'>&nbsp;をクリックするとファイルSaveダイアログが表示されます。",
		"<img class='btnCommand' src='../imgMSC/save22.png'>&nbsp;をクリックするとファイルSaveダイアログが表示されます。",
		"Clicking <img class='btnCommand' src='../imgMSC/save22.png'> will display the file Save dialog.",
		"<img class='btnCommand' src='../imgMSC/save22.png'>&nbsp;를 클릭하면 파일 저장 대화상자가 표시됩니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//保存ファイル名（拡張子：.msd）を指定して、［保存］ボタンをクリックすることで、譜面データを保存できます。
	//================================================
	[	"保存ファイル名（拡張子：.msd）を指定して、［保存］ボタンをクリックすることで、譜面データを保存できます。",
		"保存ファイル名（拡張子：.msd）を指定して、［保存］ボタンをクリックすることで、譜面データを保存できます。",
		"You can save the music score data by specifying the file name (extension: .msd) and clicking the [Save] button.",
		"저장 파일 이름(확장자: .msd)을 지정하고 저장 버튼을 클릭하여 악보 데이터를 저장할 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//編集中の楽曲の「楽譜」または「abcjsソース」を印刷します。
	//================================================
	[	"編集中の楽曲の「楽譜」または「abcjsソース」を印刷します。",
		"編集中の楽曲の「楽譜」または「abcjsソース」を印刷します。",
		"Prints the \"sheet music\" or \"abcjs source\" of the song you are editing.",
		"편집 중인 곡의 \"악보\" 또는 \"abcjs 소스\"를 인쇄합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//<img class='btnCommand' src='../imgMSC/print22.png'>&nbsp;をクリックすると印刷内容の選択ダイアログが表示されます。
	//================================================
	[	"<img class='btnCommand' src='../imgMSC/print22.png'>&nbsp;をクリックすると印刷内容の選択ダイアログが表示されます。",
		"<img class='btnCommand' src='../imgMSC/print22.png'>&nbsp;をクリックすると印刷内容の選択ダイアログが表示されます。",
		"Clicking <img class='btnCommand' src='../imgMSC/print22.png'> will display a dialog for selecting what to print.",
		"<img class='btnCommand' src='../imgMSC/print22.png'>&nbsp;를 클릭하면 인쇄 내용 선택 대화 상자가 표시됩니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//印刷内容を選択して、［印刷］ボタンをクリックすることで、指定データを印刷できます。
	//================================================
	[	"印刷内容を選択して、［印刷］ボタンをクリックすることで、指定データを印刷できます。",
		"印刷内容を選択して、［印刷］ボタンをクリックすることで、指定データを印刷できます。",
		"You can print the specified data by selecting the print content and clicking the [Print] button.",
		"인쇄 내용을 선택하고 [인쇄] 버튼을 클릭하여 지정된 데이터를 인쇄할 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//（注）譜面データは、A4版１ページに収まる様に縮小されるので、段数の多い楽譜の場合は、小さく印刷されます。
	//================================================
	[	"（注）譜面データは、A4版１ページに収まる様に縮小されるので、段数の多い楽譜の場合は、小さく印刷されます。",
		"（注）譜面データは、A4版１ページに収まる様に縮小されるので、段数の多い楽譜の場合は、小さく印刷されます。",
		"(Note) Music score data is reduced to fit on one A4 page, so if the score has many lines, it will be printed small.",
		"(주)보면 데이터는, A4판 1페이지에 들어가도록 축소되므로, 단수가 많은 악보의 경우는, 작게 인쇄됩니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//編集中の楽曲を演奏します。
	//================================================
	[	"編集中の楽曲を演奏します。",
		"編集中の楽曲を演奏します。",
		"Play the song you are editing.",
		"편집 중인 곡을 연주합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//<img class='btnCommand' src='../imgMSC/sound22.png'>&nbsp;をクリックするとメニューの下段に演奏コントロールが表示され、「演奏モード」となります。
	//================================================
	[	"<img class='btnCommand' src='../imgMSC/sound22.png'>&nbsp;をクリックするとメニューの下段に演奏コントロールが表示され、「演奏モード」となります。",
		"<img class='btnCommand' src='../imgMSC/sound22.png'>&nbsp;をクリックするとメニューの下段に演奏コントロールが表示され、「演奏モード」となります。",
		"Clicking <img class='btnCommand' src='../imgMSC/sound22.png'> will display the performance controls at the bottom of the menu and enter \"Performance mode.\"",
		"<img class='btnCommand' src='../imgMSC/sound22.png'>&nbsp;를 클릭하면 메뉴 하단에 연주 컨트롤이 표시되어 '연주 모드'가 됩니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//演奏を開始します。
	//================================================
	[	"演奏を開始します。",
		"演奏を開始します。",
		"Start playing.",
		"연주를 시작합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//演奏を停止します（演奏中に表示されます。）。
	//================================================
	[	"演奏を停止します（演奏中に表示されます。）。",
		"演奏を停止します（演奏中に表示されます。）。",
		"Stops playback (displayed during playback).",
		"연주를 중지합니다(연주 중에 표시됩니다.).",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//演奏位置を楽曲の先頭に戻します。
	//================================================
	[	"演奏位置を楽曲の先頭に戻します。",
		"演奏位置を楽曲の先頭に戻します。",
		"Returns the playing position to the beginning of the song.",
		"연주 위치를 음악의 시작 부분으로 되돌립니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//演奏位置を移動します（スライダーの移動先をクリックすることで移動できます。）。
	//================================================
	[	"演奏位置を移動します（スライダーの移動先をクリックすることで移動できます。）。",
		"演奏位置を移動します（スライダーの移動先をクリックすることで移動できます。）。",
		"Move the playing position (you can move it by clicking the destination of the slider).",
		"연주 위치를 이동합니다(슬라이더의 이동 대상을 클릭하여 이동할 수 있습니다.).",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//「演奏モード」を終了します。
	//================================================
	[	"「演奏モード」を終了します。",
		"「演奏モード」を終了します。",
		"Exit \"Perform Mode\".",
		"\"연주 모드\"를 종료합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//abcjsエディタの表示
	//================================================
	[	"abcjsエディタの表示",
		"abcjsエディタの表示",
		"Display of abcjs editor",
		"abcjs 편집기 표시",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//abcjsエディタにチェックを入れると、メニューと譜面の間に「abcjsエディタ」が表示されます。
	//================================================
	[	"abcjsエディタにチェックを入れると、メニューと譜面の間に「abcjsエディタ」が表示されます。",
		"abcjsエディタにチェックを入れると、メニューと譜面の間に「abcjsエディタ」が表示されます。",
		"If you check the abcjs editor, the \"abcjs editor\" will be displayed between the menu and the music score.",
		"abcjs 편집기를 체크하면 메뉴와 악보 사이에 \"abcjs 편집기\" 가 표시됩니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//「abcjsエディタ」で編集した内容は、譜面上に直ちに反映されます。
	//================================================
	[	"「abcjsエディタ」で編集した内容は、譜面上に直ちに反映されます。",
		"「abcjsエディタ」で編集した内容は、譜面上に直ちに反映されます。",
		"Any edits you make in the \"abcjs editor\" are immediately reflected on the musical score.",
		"\"abcjs 편집기\"에서 편집한 내용은 악보에 즉시 반영됩니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//（注）「MSC-Editor」が対応しない変更を行った場合、「MSC-Editor」が正常に機能しなくなることがあります。
	//================================================
	[	"（注）「MSC-Editor」が対応しない変更を行った場合、「MSC-Editor」が正常に機能しなくなることがあります。",
		"（注）「MSC-Editor」が対応しない変更を行った場合、「MSC-Editor」が正常に機能しなくなることがあります。",
		"(Note) If you make changes that the \"MSC-Editor\" does not support, the \"MSC-Editor\" may no longer function properly.",
		"(주) 「MSC-Editor」가 대응하지 않는 변경을 실시한 경우, 「MSC-Editor」가 정상적으로 기능하지 않는 경우가 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//したがって、「abcjsエディタ」による編集には、十分に注意をしてください。
	//================================================
	[	"したがって、「abcjsエディタ」による編集には、十分に注意をしてください。",
		"したがって、「abcjsエディタ」による編集には、十分に注意をしてください。",
		"Therefore, please be careful when editing with the \"abcjs editor\".",
		"그러므로 \"abcjs 편집기|\" 에 의한 편집에 주의를 기울여야 합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//操作説明
	//================================================
	[	"操作説明",
		"操作説明",
		"Operating Instructions",
		"조작 설명",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//演奏時の音色の変更
	//================================================
	[	"演奏時の音色の変更",
		"演奏時の音色の変更",
		"Changing the tone when playing",
		"연주시 음색 변경",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//演奏時の譜面上部のプルダウンメニューで、演奏時の音色を変更できます。
	//================================================
	[	"演奏時の譜面上部のプルダウンメニューで、演奏時の音色を変更できます。",
		"演奏時の譜面上部のプルダウンメニューで、演奏時の音色を変更できます。",
		"You can change the tone of the music being played by using the pull-down menu at the top of the score when playing.",
		"연주 시 악보 상단의 풀다운 메뉴에서 연주 시 음색을 변경할 수 있습니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//不完全小節の設定・解除
	//================================================
	[	"不完全小節の設定・解除",
		"不完全小節の設定・解除",
		"Incomplete Measure Settings / Removal",
		"불완전 마디 설정 / 해제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符・休符を削除して不完全小節にしたり、不完全小節を完全小節に戻したりします。
	//================================================
	[	"不完全小節の設定・解除",
		"不完全小節の設定・解除",
		"Deletes the selected notes or rests to create an incomplete measure or restores an incomplete measure to a complete measure.",
		"선택한 음표나 쉼표를 삭제하여 불완전 마디로 만들거나, 불완전 마디를 완전 마디로 되돌립니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//音符・休符を削除して不完全小節にします。
	//================================================
	[	"音符・休符を削除して不完全小節にします。",
		"音符・休符を削除して不完全小節にします。",
		"Deletes notes or rests to create an incomplete measure.",
		"음표나 쉼표를 삭제하여 불완전 마디로 만듭니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択中の音符・休符を含む不完全小節を完全小節に戻します。
	//================================================
	[	"選択中の音符・休符を含む不完全小節を完全小節に戻します。",
		"選択中の音符・休符を含む不完全小節を完全小節に戻します。",
		"Restores an incomplete measure that contains the selected notes or rests to a complete measure.",
		"선택한 음표나 쉼표가 포함된 불완전 마디를 완전 마디로 되돌립니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//装飾音符の配置・削除
	//================================================
	[	"装飾音符の配置・削除",
		"装飾音符の配置・削除",
		"Ornament Note Placement / Removal",
		"꾸밈음 배치 / 삭제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符に、装飾音符を設定したり、削除したりします。
	//================================================
	[	"選択している音符に、装飾音符を設定したり、削除したりします。",
		"選択している音符に、装飾音符を設定したり、削除したりします。",
		"Adds or removes an ornament note to the selected note.",
		"선택한 음표에 꾸밈음을 설정하거나 삭제합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//装飾音符の設定
	//================================================
	[	"装飾音符の設定",
		"装飾音符の設定",
		"Ornament Note Settings",
		"꾸밈음 설정",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//装飾音符設定ダイアログが表示されるので、装飾音符や臨時記号を設定し、［OK］ボタンをクリックして下さい。
	//================================================
	[	"装飾音符設定ダイアログが表示されるので、装飾音符や臨時記号を設定し、［OK］ボタンをクリックして下さい。",
		"装飾音符設定ダイアログが表示されるので、装飾音符や臨時記号を設定し、［OK］ボタンをクリックして下さい。",
		"The ornament note settings dialog will appear. Configure the ornament notes and accidentals, then click the \"OK\" button.",
		"꾸밈음 설정 대화상자가 표시됩니다. 꾸밈음이나 임시표를 설정한 후 [확인] 버튼을 클릭하십시오.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//複旋律の設定・解除
	//================================================
	[	"複旋律の設定・解除",
		"複旋律の設定・解除",
		"Multiple Voices Settings / Removal",
		"복성부 설정 / 해제",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//選択している音符・休符を含む小節に複旋律を設定したり、設定されている複旋律を削除したりします。
	//================================================
	[	"選択している音符・休符を含む小節に複旋律を設定したり、設定されている複旋律を削除したりします。",
		"選択している音符・休符を含む小節に複旋律を設定したり、設定されている複旋律を削除したりします。",
		"Adds multiple voices to the measure containing the selected notes or rests, or removes the currently set multiple voices.",
		"선택한 음표나 쉼표가 포함된 마디에 복성부를 설정하거나, 설정된 복성부를 삭제합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//音符・休符を含む小節に複旋律を設定します。
	//================================================
	[	"音符・休符を含む小節に複旋律を設定します。",
		"音符・休符を含む小節に複旋律を設定します。",
		"Adds multiple voices to the measure containing the selected notes or rests.",
		"음표나 쉼표가 포함된 마디에 복성부를 설정합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],

	//================================================
	//設定されている複旋律を削除します。
	//================================================
	[	"設定されている複旋律を削除します。",
		"設定されている複旋律を削除します。",
		"Removes the currently set multiple voices.",
		"설정된 복성부를 삭제합니다.",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],














	//================================================
	//MIDI音色名とカテゴリー
	//================================================
	// Piano
	["ピアノ", "ピアノ", "Piano", "피아노", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["アコースティック ピアノ", "アコースティック ピアノ", "Acoustic Piano", "어쿠스틱 피아노", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ブライトピアノ", "ブライトピアノ", "Bright Piano", "브라이트 피아노", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["エレクトリック グランドピアノ", "エレクトリック グランドピアノ", "Electric Grand Piano", "일렉트릭 그랜드 피아노", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ホンキートンク ピアノ", "ホンキートンク ピアノ", "Honky-tonk Piano", "혼키통크 피아노", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["エレクトリック ピアノ", "エレクトリック ピアノ", "Electric Piano", "일렉트릭 피아노", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["エレクトリック ピアノ2", "エレクトリック ピアノ2", "Electric Piano 2", "일렉트릭 피아노 2", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ハープシコード（チェンバロ）", "ハープシコード（チェンバロ）", "Harpsichord", "하프시코드 (쳄발로)", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["クラビコード", "クラビコード", "Clavi", "클라비코드", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Chromatic Percussion
	["音階付き打楽器", "音階付き打楽器", "Chromatic Percussion", "음계 타악기", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["チェレスタ", "チェレスタ", "Celesta", "첼레스타", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["グロッケンシュピール", "グロッケンシュピール", "Glockenspiel", "글로켄슈필", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["オルゴール", "オルゴール", "Musical box", "뮤직박스", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ビブラフォン", "ビブラフォン", "Vibraphone", "비브라폰", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["マリンバ", "マリンバ", "Marimba", "마림바", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["シロフォン（木琴）", "シロフォン（木琴）", "Xylophone", "실로폰 (목금)", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["チューブラーベル", "チューブラーベル", "Tubular Bell", "튜블라 벨", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ダルシマー", "ダルシマー", "Dulcimer", "덜시머", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Organ
	["オルガン", "オルガン", "Organ", "오르간", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ドローバーオルガン", "ドローバーオルガン", "Drawbar Organ", "드로바 오르간", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["パーカッシブオルガン", "パーカッシブオルガン", "Percussive Organ", "퍼커시브 오르간", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ロックオルガン", "ロックオルガン", "Rock Organ", "록 오르간", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["チャーチ オルガン", "チャーチ オルガン", "Church Organ", "처치 오르간", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["リード オルガン", "リード オルガン", "Reed Organ", "리드 오르간", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["アコーディオン", "アコーディオン", "Accordion", "아코디언", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ハーモニカ", "ハーモニカ", "Harmonica", "하모니카", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["タンゴアコーディオン（バンドネオン）", "タンゴアコーディオン（バンドネオン）", "Tango Accordion", "탱고 아코디언 (반도네온)", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Guitar
	["ギター", "ギター", "Guitar", "기타", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["クラシックギター（ナイロン弦）", "クラシックギター（ナイロン弦）", "Acoustic Guitar (nylon)", "클래식 기타 (나일론 줄)", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["アコースティックギター（スチール弦）", "アコースティックギター（スチール弦）", "Acoustic Guitar (steel)", "어쿠스틱 기타 (스틸 줄)", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ジャズギター", "ジャズギター", "Electric Guitar (jazz)", "재즈 기타", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["クリーン ギター", "クリーン ギター", "Electric Guitar (clean)", "클린 기타", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ミュート ギター", "ミュート ギター", "Electric Guitar (muted)", "뮤트 기타", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["オーバードライブ ギター", "オーバードライブ ギター", "Overdriven Guitar", "오버드라이브 기타", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ディストーション ギター", "ディストーション ギター", "Distortion Guitar", "디스토션 기타", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ギター ハーモニクス", "ギター ハーモニクス", "Guitar harmonics", "기타 하모닉스", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Bass
	["ベース", "ベース", "Bass", "베이스", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["アコースティック ベース", "アコースティック ベース", "Acoustic Bass", "어쿠스틱 베이스", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["フィンガー ベース", "フィンガー ベース", "Electric Bass (finger)", "핑거 베이스", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ピック ベース", "ピック ベース", "Electric Bass (pick)", "픽 베이스", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["フレットレス ベース", "フレットレス ベース", "Fretless Bass", "프렛리스 베이스", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["スラップベース", "スラップベース", "Slap Bass 1", "슬랩 베이스", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["スラップベース 2", "スラップベース 2", "Slap Bass 2", "슬랩 베이스 2", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["シンセベース 1", "シンセベース 1", "Synth Bass 1", "신스 베이스 1", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["シンセベース 2", "シンセベース 2", "Synth Bass 2", "신스 베이스 2", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Strings
	["ストリングス", "ストリングス", "Strings", "현악기", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["バイオリン", "バイオリン", "Violin", "바이올린", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ビオラ", "ビオラ", "Viola", "비올라", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["チェロ", "チェロ", "Cello", "첼로", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["コントラバス", "コントラバス", "Double bass", "콘트라베이스", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["トレモロ", "トレモロ", "Tremolo Strings", "트레몰로 스트링스", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ピッチカート", "ピッチカート", "Pizzicato Strings", "피치카토 스트링스", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["オーケストラ ハープ", "オーケストラ ハープ", "Orchestral Harp", "오케스트라 하프", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ティンパニ", "ティンパニ", "Timpani", "팀파니", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Ensemble
	["アンサンブル", "アンサンブル", "Ensemble", "앙상블", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ストリング アンサンブル 1", "ストリング アンサンブル 1", "String Ensemble 1", "스트링 앙상블 1", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ストリング アンサンブル 2", "ストリング アンサンブル 2", "String Ensemble 2", "스트링 앙상블 2", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["シンセストリングス 1", "シンセストリングス 1", "Synth Strings 1", "신스 스트링스 1", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["シンセストリングス 2", "シンセストリングス 2", "Synth Strings 2", "신스 스트링스 2", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["「あー」という人の声", "「あー」という人の声", "Voice Aahs", "\"아-\"라는 사람의 목소리", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["「おー」という人の声", "「おー」という人の声", "Voice Oohs", "\"오-\"라는 사람의 목소리", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["シンセ ボイス", "シンセ ボイス", "Synth Voice", "신스 보이스", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["オーケストラ ヒット", "オーケストラ ヒット", "Orchestra Hit", "오케스트라 히트", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Brass
	["ブラス", "ブラス", "Brass", "금관악기", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["トランペット", "トランペット", "Trumpet", "트럼펫", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["トロンボーン", "トロンボーン", "Trombone", "트롬본", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["チューバ", "チューバ", "Tuba", "튜바", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ミュート トランペット", "ミュート トランペット", "Muted Trumpet", "뮤트 트럼펫", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["フレンチ ホルン", "フレンチ ホルン", "French Horn", "프렌치 호른", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ブラス セクション", "ブラス セクション", "Brass Section", "브라스 섹션", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["シンセブラス 1", "シンセブラス 1", "Synth Brass 1", "신스 브라스 1", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["シンセブラス 2", "シンセブラス 2", "Synth Brass 2", "신스 브라스 2", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Reed
	["リード", "リード", "Reed", "리드 악기", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ソプラノ サックス", "ソプラノ サックス", "Soprano Sax", "소프라노 색소폰", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["アルト サックス", "アルト サックス", "Alto Sax", "알토 색소폰", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["テナー サックス", "テナー サックス", "Tenor Sax", "테너 색소폰", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["バリトン サックス", "バリトン サックス", "Baritone Sax", "바리톤 색소폰", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["オーボエ", "オーボエ", "Oboe", "오보에", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["イングリッシュ ホルン", "イングリッシュ ホルン", "English Horn", "잉글리시 호른", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["バスーン／ファゴット", "バスーン／ファゴット", "Bassoon", "바순", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["クラリネット", "クラリネット", "Clarinet", "클라리넷", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Pipe
	["笛／木管", "笛／木管", "Pipe", "목관악기", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ピッコロ", "ピッコロ", "Piccolo", "피콜로", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["フルート", "フルート", "Flute", "플루트", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["リコーダー", "リコーダー", "Recorder", "리코더", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["パンフルート", "パンフルート", "Pan Flute", "팬플루트", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ボトル", "ボトル", "Blown Bottle", "블론 보틀", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["尺八", "尺八", "Shakuhachi", "샤쿠하치", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["口笛", "口笛", "Whistle", "휘파람", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["オカリナ", "オカリナ", "Ocarina", "오카리나", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Synth Lead
	["シンセリード", "シンセリード", "Synth Lead", "신스 리드", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["矩形波", "矩形波", "Lead 1 (square)", "정사각형파", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ノコギリ波", "ノコギリ波", "Lead 2 (sawtooth)", "톱니파", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["カリオペ", "カリオペ", "Lead 3 (calliope)", "칼리오페", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["チフ", "チフ", "Lead 4 (chiff)", "치프", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["チャラング", "チャラング", "Lead 5 (charang)", "차랑", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["声", "声", "Lead 6 (voice)", "목소리", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["フィフスズ", "フィフスズ", "Lead 7 (fifths)", "피프스", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["バス + リード", "バス + リード", "Lead 8 (bass + lead)", "베이스 + 리드", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Synth Pad
	["シンセパッド", "シンセパッド", "Synth Pad", "신스 패드", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ファンタジア", "ファンタジア", "Pad 1 (Fantasia)", "판타지아", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ウォーム", "ウォーム", "Pad 2 (warm)", "웜", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ポリシンセ", "ポリシンセ", "Pad 3 (polysynth)", "폴리신스", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["クワイア", "クワイア", "Pad 4 (choir)", "합창", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ボウ", "ボウ", "Pad 5 (bowed)", "활", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["メタリック", "メタリック", "Pad 6 (metallic)", "메탈릭", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ハロー", "ハロー", "Pad 7 (halo)", "헤일로", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["スウィープ", "スウィープ", "Pad 8 (sweep)", "스윕", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Synth Effects
	["シンセエフェクト", "シンセエフェクト", "Synth Effects", "신스 효과음", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["雨", "雨", "FX 1 (rain)", "비", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["サウンドトラック", "サウンドトラック", "FX 2 (soundtrack)", "사운드트랙", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["クリスタル", "クリスタル", "FX 3 (crystal)", "크리스탈", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["アトモスフィア", "アトモスフィア", "FX 4 (atmosphere)", "분위기", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ブライトネス", "ブライトネス", "FX 5 (brightness)", "밝기", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ゴブリン", "ゴブリン", "FX 6 (goblins)", "고블린", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["エコー", "エコー", "FX 7 (echoes)", "에코", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["サイファイ", "サイファイ", "FX 8 (sci-fi)", "SF", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Ethnic
	["エスニック／民族楽器", "エスニック／民族楽器", "Ethnic", "에스닉 / 민족 악기", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["シタール", "シタール", "Sitar", "시타르", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["バンジョー", "バンジョー", "Banjo", "밴조", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["三味線", "三味線", "Shamisen", "삼미센", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["琴／箏", "琴／箏", "Koto", "고토", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["カリンバ", "カリンバ", "Kalimba", "칼림바", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["バグパイプ", "バグパイプ", "Bagpipe", "백파이프", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["フィドル", "フィドル", "Fiddle", "피들", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["シャハナイ", "シャハナイ", "Shanai", "샤나이", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Percussive
	["打楽器", "打楽器", "Percussive", "타악기", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ティンクルベル", "ティンクルベル", "Tinkle Bell", "딩글벨", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["アゴゴ ベル", "アゴゴ ベル", "Agogo", "아고고 벨", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["スチールパン", "スチールパン", "Steel Drums", "스틸 드럼", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ウッド ブロック", "ウッド ブロック", "Woodblock", "우드블록", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["太鼓", "太鼓", "Taiko Drum", "타이코 드럼", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["メロディックタム", "メロディックタム", "Melodic Tom", "멜로딕 탐", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["シンセドラム", "シンセドラム", "Synth Drum", "신스 드럼", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["リバースシンバル", "リバースシンバル", "Reverse Cymbal", "리버스 심벌", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],

	// Sound effects
	["効果音", "効果音", "Sound effects", "효과음", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ギターフレットノイズ", "ギターフレットノイズ", "Guitar Fret Noise", "기타 프렛 노이즈", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ブレスノイズ", "ブレスノイズ", "Breath Noise", "호흡 소리", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["海岸", "海岸", "Seashore", "바다 소리", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["鳥のさえずり", "鳥のさえずり", "Bird Tweet", "새 소리", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["電話のベル", "電話のベル", "Telephone Ring", "전화벨 소리", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ヘリコプター", "ヘリコプター", "Helicopter", "헬리콥터", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["拍手", "拍手", "Applause", "박수", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["ガンショット（銃声）", "ガンショット（銃声）", "Gunshot", "총소리", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],
	["パーカッション", "パーカッション", "Percussion", "충격", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""],





	//================================================
	//予備
	//================================================
	[	"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	],
];


//---------------------------------------------------------
//	言語設定の初期化
//---------------------------------------------------------
function MSC_initLang(lang, containerId) {

	//引数言語（lang）の処理
	if (lang == "auto") {
		let langCode = (window.navigator.language).substr(0, 2).toLowerCase();
		var idx = MSC_langTypes.indexOf(langCode);
		
	} else {
		var idx = MSC_langTypes.indexOf(lang);
	}
	//リストに無い言語（英語にする）
	if (idx == -1) {
		MSC_langIndex = 2;
		MSC_langCode = "en";
	} else {
		MSC_langIndex = idx;
		MSC_langCode = MSC_langTypes[idx];
	}

	//------------------------------------------------------
	//テキストデータの差替え
	//------------------------------------------------------
	//class="lang"のinnerHTMLの処理
	var container = document.getElementById(containerId);
	var elems = container.getElementsByClassName("MSC_lang");
	for (let i = 0; i < elems.length; i++) {
		let tmp = elems[i].innerHTML;
		tmp = MAC_convLang(tmp);
		elems[i].innerHTML = tmp;
	}
	
	//titleの処理
	var elems = container.querySelectorAll("*");
	for (let i = 0; i < elems.length; i++) {
		if (elems[i].hasAttribute('title')) {
			let tmp = elems[i].getAttribute('title');
			tmp = MAC_convLang(tmp);
			elems[i].setAttribute('title', tmp);
		}
	}

	//selectの処理（速度記号）
	var elem = document.getElementById("selTempoMarkings");
	for (let i = 0; i < elem.options.length; i++) {
		let tmp = elem.options[i].text;
		tmp = MAC_convLang(tmp);
		elem.options[i].text = tmp;
	}

	//selectの処理（楽譜行数）
	var elem = document.getElementById("selRowsCount");
	for (let i = 0; i < elem.options.length; i++) {
		let tmp = elem.options[i].text;
		tmp = MAC_convLang(tmp);
		elem.options[i].text = tmp;
	}

	//selectの処理（歌詞番数）
	var elem = document.getElementById("selLyric");
	for (let i = 0; i < elem.options.length; i++) {
		let tmp = elem.options[i].text;
		tmp = MAC_convLang(tmp);
		elem.options[i].text = tmp;
	}

	//selectの処理（強弱記号）
	var elem = document.getElementById("selDynamics");
	for (let i = 0; i < elem.options.length; i++) {
		let tmp = elem.options[i].text;
		tmp = MAC_convLang(tmp);
		elem.options[i].text = tmp;

		elem.options[i].text = elem.options[i].text.replace("始点", MAC_convLang("始点"));
		elem.options[i].text = elem.options[i].text.replace("終点", MAC_convLang("終点"));
	}

	//selectの処理（反復記号）
	var elem = document.getElementById("selRepeatSigns");
	for (let i = 0; i < elem.options.length; i++) {
		let tmp = elem.options[i].text;
		tmp = MAC_convLang(tmp);
		elem.options[i].text = tmp;
	}
	
	//selectの処理（MiDi音色）
	var elem = document.getElementById("selMidiNo");
	if (elem) {
		for (let i = 0; i < elem.options.length; i++) {
			let tmp = elem.options[i].text;
			tmp = MAC_convLang(tmp);
			elem.options[i].text = tmp;
		}
	}
	
	//------------------------------------------------------
	//イメージファイルの差替え
	//------------------------------------------------------
	if (location.href.indexOf("manual") != -1 || location.href.indexOf("office") != -1) {
		var imgPath = "../imgMSC";
	} else {
		var imgPath = "./imgMSC";
	}
	
	//調号選択イメージ
	document.getElementById("imgKey_C").src = imgPath + "/key_C_" + MSC_langCode + ".png";
	document.getElementById("imgKey_G").src = imgPath + "/key_G_" + MSC_langCode + ".png";
	document.getElementById("imgKey_D").src = imgPath + "/key_D_" + MSC_langCode + ".png";
	document.getElementById("imgKey_A").src = imgPath + "/key_A_" + MSC_langCode + ".png";
	document.getElementById("imgKey_E").src = imgPath + "/key_E_" + MSC_langCode + ".png";
	document.getElementById("imgKey_B").src = imgPath + "/key_B_" + MSC_langCode + ".png";
	document.getElementById("imgKey_Fs").src = imgPath + "/key_Fs_" + MSC_langCode + ".png";
	document.getElementById("imgKey_Cs").src = imgPath + "/key_Cs_" + MSC_langCode + ".png";
	document.getElementById("imgKey_F").src = imgPath + "/key_F_" + MSC_langCode + ".png";
	document.getElementById("imgKey_Bf").src = imgPath + "/key_Bf_" + MSC_langCode + ".png";
	document.getElementById("imgKey_Ef").src = imgPath + "/key_Ef_" + MSC_langCode + ".png";
	document.getElementById("imgKey_Af").src = imgPath + "/key_Af_" + MSC_langCode + ".png";
	document.getElementById("imgKey_Df").src = imgPath + "/key_Df_" + MSC_langCode + ".png";
	document.getElementById("imgKey_Gf").src = imgPath + "/key_Gf_" + MSC_langCode + ".png";
	document.getElementById("imgKey_Cf").src = imgPath + "/key_Cf_" + MSC_langCode + ".png";

	//曲名・作者ボタンイメージ
	document.getElementById("imgTitle").src = imgPath + "/title_" + MSC_langCode + ".png";
}

//---------------------------------------------------------
//	文字列変換（引数なし）
//---------------------------------------------------------
function MAC_convLang(jpStr) {
	var str = jpStr
	//日本語以外の場合
	if (MSC_langIndex != 0) {
		for (let i = 0; i < MSC_langStr.length; i++) {
			if (MSC_langStr[i][0] == jpStr) {
				str = MSC_langStr[i][MSC_langIndex];
				break;
			}
		}
	}
	return str;
}
//---------------------------------------------------------
//	文字列変換（引数あり、1のみ別処理＝英語の単数・複数の関係）
//---------------------------------------------------------
function MAC_convLang_1(jpStr, val) {
	var str = jpStr;
	if (val == 1) {
		str = MAC_convLang(jpStr.replace("%1", val));
	} else {
		str = MAC_convLang(jpStr).replace("%1", val);
	}
	return str;
}
//---------------------------------------------------------
//	文字列変換（引数あり、1～3を別処理＝英語の1st、2nd、3rdの関係）
//---------------------------------------------------------
function MAC_convLang_3(jpStr, val) {
	var str = jpStr;
	if (val <= 3) {
		str = MAC_convLang(jpStr.replace("%1", val));
	} else {
		str = MAC_convLang(jpStr).replace("%1", val);
	}
	return str;
}
